/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.FileBasedDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.datasource.parser.NumberVectorLabelParser;
import elki.datasource.parser.Parser;
import elki.datasource.parser.StreamingParser;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileListParameter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

public class ConcatenateFilesDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ConcatenateFilesDatabaseConnection.class);
    private List<URI> files;
    private Parser parser;

    public ConcatenateFilesDatabaseConnection(List<URI> files, Parser parser, List<? extends ObjectFilter> filters) {
        super(filters);
        this.files = files;
        this.parser = parser;
    }

    /*
     * Unable to fully structure code
     */
    public MultipleObjectsBundle loadData() {
        objects = new MultipleObjectsBundle();
        objects.appendColumn(TypeUtil.STRING, new ArrayList<E>());
lbl4:
        // 4 sources

        for (URI file : this.files) {
            filestr = file.toString();
            try {
                inputStream = FileUtil.open((URI)file, (OpenOption[])new OpenOption[0]);
                try {
                    if (this.parser instanceof StreamingParser) {
                        streamParser = (StreamingParser)this.parser;
                        streamParser.initStream(inputStream);
                        source = streamParser;
                    } else {
                        parsingResult = this.parser.parse(inputStream);
                        source = parsingResult.asStream();
                    }
                    meta = null;
                    e = source.nextEvent();
                    block13: while (true) {
                        switch (1.$SwitchMap$elki$datasource$bundle$BundleStreamSource$Event[e.ordinal()]) {
                            case 1: {
                                ** break;
                            }
                            case 2: {
                                meta = source.getMeta();
                                for (i = 0; i < meta.size(); ++i) {
                                    if (i + 1 >= objects.metaLength()) {
                                        objects.appendColumn((SimpleTypeInformation)meta.get(i), new ArrayList<E>());
                                        continue;
                                    }
                                    if (objects.meta(i + 1).isAssignableFromType((TypeInformation)meta.get(i))) continue;
                                    throw new AbortException("Incompatible files loaded. Cannot concatenate with unaligned columns, please preprocess manually.");
                                }
                                ** GOTO lbl41
                            }
                            case 3: {
                                o = new Object[objects.metaLength()];
                                o[0] = filestr;
                                if (meta == null) {
                                    throw new IllegalStateException("Data without metadata in stream " + source.toString());
                                }
                                for (i = 0; i < meta.size(); ++i) {
                                    o[i + 1] = source.data(i);
                                }
                                objects.appendSimple(o);
                            }
lbl41:
                            // 3 sources

                            default: {
                                e = source.nextEvent();
                                continue block13;
                            }
                        }
                        break;
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new AbortException("Loading file " + filestr + " failed: " + e.toString(), (Throwable)e);
            }
        }
        this.parser.cleanup();
        if (ConcatenateFilesDatabaseConnection.LOG.isDebugging()) {
            ConcatenateFilesDatabaseConnection.LOG.debugFine((CharSequence)"Invoking filters.");
        }
        return this.invokeBundleFilters(objects);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        public static final OptionID INPUT_ID = FileBasedDatabaseConnection.Par.INPUT_ID;
        private List<URI> files;

        public void configure(Parameterization config) {
            super.configure(config);
            new FileListParameter(INPUT_ID, FileListParameter.FilesType.INPUT_FILES).grab(config, x -> {
                this.files = x;
            });
            this.configFilters(config);
            this.configParser(config, Parser.class, NumberVectorLabelParser.class);
        }

        public ConcatenateFilesDatabaseConnection make() {
            return new ConcatenateFilesDatabaseConnection(this.files, this.parser, this.filters);
        }
    }
}

