/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDFactory;
import elki.datasource.DatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.utilities.documentation.Description;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

@Description(value="This class generates a sequence of DBIDs to 'load' into a database. This is useful when using an external data matrix, and not requiring access to the actual vectors.")
public class DBIDRangeDatabaseConnection
implements DatabaseConnection {
    int start;
    int count;

    public DBIDRangeDatabaseConnection(int start, int count) {
        this.start = start;
        this.count = count;
    }

    public MultipleObjectsBundle loadData() {
        MultipleObjectsBundle b = new MultipleObjectsBundle();
        b.setDBIDs((ArrayDBIDs)DBIDFactory.FACTORY.generateStaticDBIDRange(this.start, this.count));
        return b;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID START_ID = new OptionID("idgen.start", "First integer DBID to generate.");
        public static final OptionID COUNT_ID = new OptionID("idgen.count", "Number of DBID to generate.");
        int start;
        int count;

        public void configure(Parameterization config) {
            new IntParameter(START_ID, 0).grab(config, x -> {
                this.start = x;
            });
            new IntParameter(COUNT_ID).grab(config, x -> {
                this.count = x;
            });
        }

        public DBIDRangeDatabaseConnection make() {
            return new DBIDRangeDatabaseConnection(this.start, this.count);
        }
    }
}

