/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.data.ExternalID;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.DatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class ExternalIDJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ExternalIDJoinDatabaseConnection.class);
    protected final List<? extends DatabaseConnection> sources;

    public ExternalIDJoinDatabaseConnection(List<? extends ObjectFilter> filters, List<? extends DatabaseConnection> sources) {
        super(filters);
        this.sources = sources;
    }

    public MultipleObjectsBundle loadData() {
        int lblcol;
        ArrayList<MultipleObjectsBundle> bundles = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection databaseConnection : this.sources) {
            bundles.add(databaseConnection.loadData());
        }
        MultipleObjectsBundle first = (MultipleObjectsBundle)bundles.get(0);
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap(first.dataLength());
        object2IntOpenHashMap.defaultReturnValue(-1);
        int lblc = -1;
        for (int i = 0; i < first.metaLength(); ++i) {
            if (!TypeUtil.EXTERNALID.isAssignableFromType((TypeInformation)first.meta(i))) continue;
            lblc = i;
            break;
        }
        if ((lblcol = lblc) == -1) {
            throw new AbortException("No external ID column found in primary source.");
        }
        for (int i = 0; i < first.dataLength(); ++i) {
            ExternalID data = (ExternalID)first.data(i, lblcol);
            if (data == null) {
                LOG.debug((CharSequence)"Object without ID encountered.");
                continue;
            }
            int old = object2IntOpenHashMap.put((Object)data, i);
            if (old == -1) continue;
            LOG.debug((CharSequence)("Duplicate id encountered: " + data + " in rows " + old + " and " + i));
        }
        for (int c = 1; c < this.sources.size(); ++c) {
            int lblcol2;
            int i;
            MultipleObjectsBundle cur = (MultipleObjectsBundle)bundles.get(c);
            int lblc2 = -1;
            for (i = 0; i < cur.metaLength(); ++i) {
                if (!TypeUtil.EXTERNALID.isAssignableFromType((TypeInformation)cur.meta(i))) continue;
                lblc2 = i;
                break;
            }
            if ((lblcol2 = lblc2) == -1) {
                StringBuilder buf = new StringBuilder();
                for (i = 0; i < cur.metaLength(); ++i) {
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    buf.append(cur.meta(i));
                }
                throw new AbortException("No external ID column found in source " + (c + 1) + " to join with. Got: " + buf.toString());
            }
            ArrayList dcol = new ArrayList(cur.metaLength());
            for (i = 0; i < cur.metaLength(); ++i) {
                if (i == lblcol2) {
                    dcol.add(null);
                    continue;
                }
                ArrayList<Object> newcol = new ArrayList<Object>(first.dataLength());
                for (int j = 0; j < first.dataLength(); ++j) {
                    newcol.add(null);
                }
                first.appendColumn(cur.meta(i), newcol);
                dcol.add(newcol);
            }
            for (i = 0; i < cur.dataLength(); ++i) {
                ExternalID data = (ExternalID)cur.data(i, lblcol2);
                if (data == null) {
                    LOG.warning((CharSequence)"Object without label encountered.");
                    continue;
                }
                int row = object2IntOpenHashMap.getInt((Object)data);
                if (row == -1) {
                    LOG.debug((CharSequence)("ID not found for join: " + data + " in row " + i));
                    continue;
                }
                for (int d = 0; d < cur.metaLength(); ++d) {
                    if (d == lblcol2) continue;
                    List col = (List)dcol.get(d);
                    assert (col != null);
                    col.set(row, cur.data(i, d));
                }
            }
        }
        block10: for (int i = 0; i < first.dataLength(); ++i) {
            for (int d = 0; d < first.metaLength(); ++d) {
                if (first.data(i, d) != null) continue;
                StringBuilder buf = new StringBuilder();
                for (int d2 = 0; d2 < first.metaLength(); ++d2) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    if (first.data(i, d2) == null) {
                        buf.append("null");
                        continue;
                    }
                    buf.append(first.data(i, d2));
                }
                LOG.warning((CharSequence)("null value in joined data, row " + i + " column " + d + FormatUtil.NEWLINE + "[" + buf.toString() + "]"));
                continue block10;
            }
        }
        return first;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<? extends DatabaseConnection> sources;

        public void configure(Parameterization config) {
            super.configure(config);
            super.configFilters(config);
            new ObjectListParameter(SOURCES_ID, DatabaseConnection.class).grab(config, x -> {
                this.sources = x;
            });
        }

        public ExternalIDJoinDatabaseConnection make() {
            return new ExternalIDJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

