/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.datasource.InputStreamDatabaseConnection;
import elki.datasource.filter.ObjectFilter;
import elki.datasource.parser.ArffParser;
import elki.datasource.parser.NumberVectorLabelParser;
import elki.datasource.parser.Parser;
import elki.utilities.Priority;
import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.FileParameter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.List;

@Priority(value=100)
public class FileBasedDatabaseConnection
extends InputStreamDatabaseConnection {
    public FileBasedDatabaseConnection(List<? extends ObjectFilter> filters, Parser parser, URI infile) {
        super(() -> {
            try {
                return new BufferedInputStream(FileUtil.open((URI)infile, (OpenOption[])new OpenOption[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not load input file: " + infile, e);
            }
        }, filters, parser);
    }

    public FileBasedDatabaseConnection(List<? extends ObjectFilter> filters, Parser parser, String infile) {
        this(filters, parser, URI.create(infile));
    }

    public FileBasedDatabaseConnection(List<? extends ObjectFilter> filters, Parser parser, InputStream in) {
        super(in, filters, parser);
    }

    public static class Par
    extends InputStreamDatabaseConnection.Par {
        public static final OptionID INPUT_ID = new OptionID("dbc.in", "The name of the input file to be parsed.");
        protected URI infile;

        @Override
        public void configure(Parameterization config) {
            new FileParameter(INPUT_ID, FileParameter.FileType.INPUT_FILE).grab(config, x -> {
                this.infile = x;
            });
            Class defaultParser = NumberVectorLabelParser.class;
            if (this.infile != null && (this.infile.toString().endsWith(".arff") || this.infile.toString().endsWith(".arff.gz"))) {
                defaultParser = ArffParser.class;
            }
            this.configParser(config, Parser.class, defaultParser);
            this.configFilters(config);
        }

        @Override
        public FileBasedDatabaseConnection make() {
            return new FileBasedDatabaseConnection((List<? extends ObjectFilter>)this.filters, this.parser, this.infile);
        }
    }
}

