/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.datasource.parser.NumberVectorLabelParser;
import elki.datasource.parser.Parser;
import elki.datasource.parser.StreamingParser;
import elki.logging.Logging;
import elki.logging.statistics.Duration;
import elki.logging.statistics.Statistic;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Supplier;

@Title(value="Input-Stream based database connection")
@Description(value="Parse an input stream such as STDIN into a database.")
public class InputStreamDatabaseConnection
extends AbstractDatabaseConnection
implements AutoCloseable {
    private static final Logging LOG = Logging.getLogger(InputStreamDatabaseConnection.class);
    Parser parser;
    Supplier<InputStream> in = () -> System.in;
    InputStream ins;

    public InputStreamDatabaseConnection(Supplier<InputStream> in, List<? extends ObjectFilter> filters, Parser parser) {
        super(filters);
        this.in = in;
        this.parser = parser;
    }

    public InputStreamDatabaseConnection(InputStream ins, List<? extends ObjectFilter> filters, Parser parser) {
        super(filters);
        this.ins = ins;
        this.parser = parser;
    }

    public MultipleObjectsBundle loadData() {
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)"Invoking parsers.");
        }
        if (this.parser instanceof StreamingParser) {
            StreamingParser streamParser = (StreamingParser)this.parser;
            this.ins = this.ins != null ? this.ins : this.in.get();
            streamParser.initStream(this.ins);
            if (LOG.isDebugging()) {
                LOG.debugFine((CharSequence)"Parsing as stream.");
            }
            Duration duration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".load").begin() : null;
            MultipleObjectsBundle objects = this.invokeStreamFilters(streamParser).asMultipleObjectsBundle();
            this.parser.cleanup();
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (duration != null) {
                LOG.statistics((Statistic)duration.end());
            }
            return objects;
        }
        Duration duration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".parse").begin() : null;
        this.ins = this.ins != null ? this.ins : this.in.get();
        MultipleObjectsBundle parsingResult = this.parser.parse(this.ins);
        this.parser.cleanup();
        try {
            this.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (duration != null) {
            LOG.statistics((Statistic)duration.end());
        }
        if (LOG.isDebugging()) {
            LOG.debugFine((CharSequence)"Invoking filters.");
        }
        Duration fduration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".filter").begin() : null;
        MultipleObjectsBundle objects = this.invokeBundleFilters(parsingResult);
        if (fduration != null) {
            LOG.statistics((Statistic)fduration.end());
        }
        return objects;
    }

    @Override
    public void close() throws IOException {
        if (this.ins != null) {
            this.ins.close();
            this.ins = null;
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        public static final OptionID STREAM_ID = new OptionID("dbc.inputstream", "Input stream to read. Defaults to standard input.");
        protected InputStream instream;

        public void configure(Parameterization config) {
            new ObjectParameter(STREAM_ID, InputStream.class, (Object)System.in).grab(config, x -> {
                this.instream = x;
            });
            this.configParser(config, Parser.class, NumberVectorLabelParser.class);
            this.configFilters(config);
        }

        public InputStreamDatabaseConnection make() {
            return new InputStreamDatabaseConnection(this.instream, (List<? extends ObjectFilter>)this.filters, this.parser);
        }
    }
}

