/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.data.LabelList;
import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.DatabaseConnection;
import elki.datasource.ExternalIDJoinDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.FilterUtil;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class LabelJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(LabelJoinDatabaseConnection.class);
    protected final List<? extends DatabaseConnection> sources;

    public LabelJoinDatabaseConnection(List<? extends ObjectFilter> filters, List<? extends DatabaseConnection> sources) {
        super(filters);
        this.sources = sources;
    }

    public MultipleObjectsBundle loadData() {
        ArrayList<MultipleObjectsBundle> bundles = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection databaseConnection : this.sources) {
            bundles.add(databaseConnection.loadData());
        }
        MultipleObjectsBundle first = (MultipleObjectsBundle)bundles.get(0);
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap(first.dataLength());
        object2IntOpenHashMap.defaultReturnValue(-1);
        int lblcol = FilterUtil.findLabelColumn(first);
        if (lblcol == -1) {
            throw new AbortException("No label column found in first source, cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
        }
        for (int i = 0; i < first.dataLength(); ++i) {
            Object data = first.data(i, lblcol);
            if (data == null) {
                LOG.warning((CharSequence)"Object without label encountered.");
                continue;
            }
            if (data instanceof String) {
                int old = object2IntOpenHashMap.put((Object)((String)data), i);
                if (old == -1) continue;
                LOG.warning((CharSequence)("Duplicate label encountered: " + data + " in rows " + old + " and " + i));
                continue;
            }
            if (data instanceof LabelList) {
                LabelList ll = (LabelList)data;
                for (int j = 0; j < ll.size(); ++j) {
                    String lbl = ll.get(j);
                    int old = object2IntOpenHashMap.put((Object)lbl, i);
                    if (old == -1) continue;
                    LOG.warning((CharSequence)("Duplicate label encountered: " + lbl + " in rows " + old + " and " + i));
                }
                continue;
            }
            String lbl = data.toString();
            int old = object2IntOpenHashMap.put((Object)lbl, i);
            if (old == -1) continue;
            LOG.warning((CharSequence)("Duplicate label encountered: " + lbl + " in rows " + old + " and " + i));
        }
        for (int c = 1; c < this.sources.size(); ++c) {
            int i;
            MultipleObjectsBundle cur = (MultipleObjectsBundle)bundles.get(c);
            int lblcol2 = FilterUtil.findLabelColumn(cur);
            if (lblcol2 == -1) {
                throw new AbortException("No label column found in source " + (c + 1) + ", cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
            }
            ArrayList dcol = new ArrayList(cur.metaLength());
            for (i = 0; i < cur.metaLength(); ++i) {
                if (i == lblcol2) {
                    dcol.add(null);
                    continue;
                }
                ArrayList<Object> newcol = new ArrayList<Object>(first.dataLength());
                for (int j = 0; j < first.dataLength(); ++j) {
                    newcol.add(null);
                }
                first.appendColumn(cur.meta(i), newcol);
                dcol.add(newcol);
            }
            for (i = 0; i < cur.dataLength(); ++i) {
                Object data = cur.data(i, lblcol2);
                if (data == null) {
                    LOG.warning((CharSequence)"Object without label encountered.");
                    continue;
                }
                int row = -1;
                if (data instanceof String) {
                    row = object2IntOpenHashMap.getInt(data);
                } else if (data instanceof LabelList) {
                    LabelList ll = (LabelList)data;
                    for (int j = 0; j < ll.size() && (row = object2IntOpenHashMap.getInt((Object)ll.get(j))) < 0; ++j) {
                    }
                } else {
                    row = object2IntOpenHashMap.getInt((Object)data.toString());
                }
                if (row < 0) {
                    LOG.warning((CharSequence)("Label not found for join: " + data + " in row " + i));
                    continue;
                }
                for (int d = 0; d < cur.metaLength(); ++d) {
                    if (d == lblcol2) continue;
                    List col = (List)dcol.get(d);
                    assert (col != null);
                    col.set(row, cur.data(i, d));
                }
            }
        }
        block9: for (int i = 0; i < first.dataLength(); ++i) {
            for (int d = 0; d < first.metaLength(); ++d) {
                if (first.data(i, d) != null) continue;
                StringBuilder buf = new StringBuilder();
                for (int d2 = 0; d2 < first.metaLength(); ++d2) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    if (first.data(i, d2) == null) {
                        buf.append("null");
                        continue;
                    }
                    buf.append(first.data(i, d2));
                }
                LOG.warning((CharSequence)("null value in joined data, row " + i + " column " + d + FormatUtil.NEWLINE + "[" + buf.toString() + "]"));
                continue block9;
            }
        }
        return first;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<? extends DatabaseConnection> sources;

        public void configure(Parameterization config) {
            super.configure(config);
            super.configFilters(config);
            new ObjectListParameter(SOURCES_ID, DatabaseConnection.class).grab(config, x -> {
                this.sources = x;
            });
        }

        public LabelJoinDatabaseConnection make() {
            return new LabelJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

