/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.DatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.utilities.documentation.Description;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.ArrayList;
import java.util.List;

@Description(value="Blindly joins multiple data sources, assuming they are ordered the same way.")
public class PresortedBlindJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(PresortedBlindJoinDatabaseConnection.class);
    protected final List<? extends DatabaseConnection> sources;

    public PresortedBlindJoinDatabaseConnection(List<? extends ObjectFilter> filters, List<? extends DatabaseConnection> sources) {
        super(filters);
        this.sources = sources;
    }

    /*
     * WARNING - void declaration
     */
    public MultipleObjectsBundle loadData() {
        void var3_5;
        ArrayList<MultipleObjectsBundle> bundles = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection databaseConnection : this.sources) {
            bundles.add(databaseConnection.loadData());
        }
        MultipleObjectsBundle first = (MultipleObjectsBundle)bundles.get(0);
        boolean bl = true;
        while (var3_5 < this.sources.size()) {
            MultipleObjectsBundle cur = (MultipleObjectsBundle)bundles.get((int)var3_5);
            if (cur.dataLength() != first.dataLength()) {
                throw new AbortException("Data set sizes do not agree - cannot join!");
            }
            for (int i = 0; i < cur.metaLength(); ++i) {
                first.appendColumn(cur.meta(i), cur.getColumn(i));
            }
            ++var3_5;
        }
        return this.invokeBundleFilters(first);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<? extends DatabaseConnection> sources;

        public void configure(Parameterization config) {
            super.configure(config);
            super.configFilters(config);
            new ObjectListParameter(SOURCES_ID, DatabaseConnection.class).grab(config, x -> {
                this.sources = x;
            });
        }

        public PresortedBlindJoinDatabaseConnection make() {
            return new PresortedBlindJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

