/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource;

import elki.data.DoubleVector;
import elki.data.FeatureVector;
import elki.data.NumberVector;
import elki.data.VectorUtil;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.AbstractDatabaseConnection;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomDoubleVectorDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(RandomDoubleVectorDatabaseConnection.class);
    protected int dim = -1;
    protected int size = -1;
    protected RandomFactory rnd;

    public RandomDoubleVectorDatabaseConnection(int dim, int size, RandomFactory rnd, List<? extends ObjectFilter> filters) {
        super(filters);
        this.dim = dim;
        this.size = size;
        this.rnd = rnd;
    }

    public MultipleObjectsBundle loadData() {
        VectorFieldTypeInformation type = new VectorFieldTypeInformation((FeatureVector.Factory)DoubleVector.FACTORY, this.dim);
        ArrayList<DoubleVector> vectors = new ArrayList<DoubleVector>(this.size);
        Random rand = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < this.size; ++i) {
            vectors.add((DoubleVector)VectorUtil.randomVector((NumberVector.Factory)DoubleVector.FACTORY, (int)this.dim, (Random)rand));
        }
        return MultipleObjectsBundle.makeSimple((SimpleTypeInformation)type, vectors);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractDatabaseConnection.Par {
        public static final OptionID SEED_ID = new OptionID("dbc.genseed", "Seed for randomly generating vectors");
        public static final OptionID DIM_ID = new OptionID("dbc.dim", "Dimensionality of the vectors to generate.");
        public static final OptionID SIZE_ID = new OptionID("dbc.size", "Database size to generate.");
        int dim = -1;
        int size = -1;
        RandomFactory rnd;

        public void configure(Parameterization config) {
            super.configure(config);
            this.configFilters(config);
            new IntParameter(DIM_ID).grab(config, x -> {
                this.dim = x;
            });
            new IntParameter(SIZE_ID).grab(config, x -> {
                this.size = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public RandomDoubleVectorDatabaseConnection make() {
            return new RandomDoubleVectorDatabaseConnection(this.dim, this.size, this.rnd, this.filters);
        }
    }
}

