/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter;

import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.exceptions.AbortException;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractConversionFilter<I, O>
implements ObjectFilter {
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (objects.dataLength() == 0) {
            return objects;
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        Logging logger = this.getLogger();
        for (int r = 0; r < objects.metaLength(); ++r) {
            Object obj;
            SimpleTypeInformation type = objects.meta(r);
            List column = objects.getColumn(r);
            if (!this.getInputTypeRestriction().isAssignableFromType((TypeInformation)type)) {
                bundle.appendColumn(type, column);
                continue;
            }
            SimpleTypeInformation castType = type;
            if (this.prepareStart(castType)) {
                FiniteProgress pprog = logger.isVerbose() ? new FiniteProgress("Preparing normalization", objects.dataLength(), logger) : null;
                Iterator iterator = column.iterator();
                while (iterator.hasNext()) {
                    Object o;
                    obj = o = iterator.next();
                    this.prepareProcessInstance(obj);
                    logger.incrementProcessed((AbstractProgress)pprog);
                }
                logger.ensureCompleted(pprog);
                this.prepareComplete();
            }
            List castColumn = column;
            bundle.appendColumn(this.convertedType(castType), castColumn);
            FiniteProgress nprog = logger.isVerbose() ? new FiniteProgress("Data normalization", objects.dataLength(), logger) : null;
            for (int i = 0; i < objects.dataLength(); ++i) {
                obj = column.get(i);
                O normalizedObj = this.filterSingleObject(obj);
                castColumn.set(i, normalizedObj);
                logger.incrementProcessed((AbstractProgress)nprog);
            }
            logger.ensureCompleted(nprog);
        }
        return bundle;
    }

    protected abstract Logging getLogger();

    protected abstract O filterSingleObject(I var1);

    protected abstract SimpleTypeInformation<? super I> getInputTypeRestriction();

    protected abstract SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<I> var1);

    protected boolean prepareStart(SimpleTypeInformation<I> in) {
        return false;
    }

    protected void prepareProcessInstance(I obj) {
        throw new AbortException("ProcessInstance not implemented, but prepareStart true?");
    }

    protected void prepareComplete() {
    }

    public String toString() {
        return this.getClass().getName();
    }
}

