/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorTypeInformation;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.logging.LoggingUtil;
import java.lang.reflect.Field;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static <V extends NumberVector> NumberVector.Factory<V> guessFactory(SimpleTypeInformation<V> in) {
        NumberVector.Factory factory = null;
        if (in instanceof VectorTypeInformation) {
            factory = (NumberVector.Factory)((VectorTypeInformation)in).getFactory();
        }
        if (factory == null) {
            try {
                Field f = in.getRestrictionClass().getField("FACTORY");
                factory = (NumberVector.Factory)f.get(null);
            }
            catch (Exception e) {
                LoggingUtil.warning((String)("Cannot determine factory for type " + in.getRestrictionClass()), (Throwable)e);
            }
        }
        return factory;
    }

    public static int findLabelColumn(MultipleObjectsBundle bundle) {
        for (int i = 0; i < bundle.metaLength(); ++i) {
            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType((TypeInformation)bundle.meta(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findLabelColumn(BundleMeta meta) {
        for (int i = 0; i < meta.size(); ++i) {
            if (!TypeUtil.GUESSED_LABEL.isAssignableFromType((TypeInformation)meta.get(i))) continue;
            return i;
        }
        return -1;
    }
}

