/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDFactory;
import elki.database.ids.DBIDRange;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

public class FixedDBIDsFilter
implements ObjectFilter {
    BundleMeta meta;
    int curid = 0;

    public FixedDBIDsFilter(int startid) {
        this.curid = startid;
    }

    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        DBIDRange ids = DBIDFactory.FACTORY.generateStaticDBIDRange(this.curid, objects.dataLength());
        objects.setDBIDs((ArrayDBIDs)ids);
        this.curid += objects.dataLength();
        return objects;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID IDSTART_ID = new OptionID("dbc.startid", "Object ID to start counting with");
        int startid = 0;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(IDSTART_ID, 0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT)).grab(config, x -> {
                this.startid = x;
            });
        }

        public FixedDBIDsFilter make() {
            return new FixedDBIDsFilter(this.startid);
        }
    }
}

