/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.cleaning;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.AbstractStreamFilter;
import elki.logging.Logging;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.Parameterizer;
import java.util.ArrayList;

public class DropNaNFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(DropNaNFilter.class);
    private long[] densecols = null;

    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    this.updateMeta(this.source.getMeta());
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (this.densecols == null) {
                        this.updateMeta(this.source.getMeta());
                    }
                    boolean good = true;
                    int j = BitsUtil.nextSetBit((long[])this.densecols, (int)0);
                    while (j >= 0) {
                        NumberVector v = (NumberVector)this.source.data(j);
                        if (v == null) {
                            good = false;
                            break;
                        }
                        for (int i = 0; i < v.getDimensionality(); ++i) {
                            if (!Double.isNaN(v.doubleValue(i))) continue;
                            good = false;
                            break;
                        }
                        j = BitsUtil.nextSetBit((long[])this.densecols, (int)(j + 1));
                    }
                    if (!good) continue block5;
                    return ev;
                }
            }
        }
    }

    private void updateMeta(BundleMeta meta) {
        int cols = meta.size();
        this.densecols = BitsUtil.zero((int)cols);
        for (int i = 0; i < cols; ++i) {
            if (TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)meta.get(i))) {
                throw new AbortException("Filtering sparse vectors is not yet supported by this filter. Please contribute.");
            }
            if (TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)meta.get(i))) {
                BitsUtil.setI((long[])this.densecols, (int)i);
                continue;
            }
            if (!TypeUtil.DOUBLE_VECTOR_FIELD.isAssignableFromType((TypeInformation)meta.get(i))) continue;
            BitsUtil.setI((long[])this.densecols, (int)i);
        }
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest((CharSequence)"Removing records with NaN values.");
        }
        this.updateMeta(objects.meta());
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int j = 0; j < objects.metaLength(); ++j) {
            bundle.appendColumn(objects.meta(j), new ArrayList());
        }
        for (int i = 0; i < objects.dataLength(); ++i) {
            Object[] row = objects.getRow(i);
            boolean good = true;
            int j = BitsUtil.nextSetBit((long[])this.densecols, (int)0);
            while (j >= 0) {
                NumberVector v = (NumberVector)row[j];
                if (v == null) {
                    good = false;
                    break;
                }
                for (int d = 0; d < v.getDimensionality(); ++d) {
                    if (!Double.isNaN(v.doubleValue(d))) continue;
                    good = false;
                    break;
                }
                j = BitsUtil.nextSetBit((long[])this.densecols, (int)(j + 1));
            }
            if (!good) continue;
            bundle.appendSimple(row);
        }
        return bundle;
    }

    public static class Par
    implements Parameterizer {
        public DropNaNFilter make() {
            return new DropNaNFilter();
        }
    }
}

