/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.cleaning;

import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.AbstractStreamFilter;
import elki.logging.Logging;
import elki.math.statistics.distribution.Distribution;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Random;

public class ReplaceNaNWithRandomFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(ReplaceNaNWithRandomFilter.class);
    private NumberVector.Factory<?>[] densecols = null;
    private Distribution dist;
    private ArrayList<Object> rows = new ArrayList();
    private Random rnd;

    public ReplaceNaNWithRandomFilter(Distribution dist, RandomFactory rnd) {
        this.dist = dist;
        this.rnd = rnd.getSingleThreadedRandom();
    }

    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    public Object data(int rnum) {
        return this.rows.get(rnum);
    }

    public BundleStreamSource.Event nextEvent() {
        while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    this.updateMeta(this.source.getMeta());
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (this.densecols == null) {
                        this.updateMeta(this.source.getMeta());
                    }
                    this.rows.clear();
                    for (int j = 0; j < this.densecols.length; ++j) {
                        Object o = this.source.data(j);
                        if (this.densecols[j] != null) {
                            NumberVector v = (NumberVector)o;
                            if (v == null) continue;
                            double[] ro = null;
                            for (int i = 0; i < v.getDimensionality(); ++i) {
                                if (!Double.isNaN(v.doubleValue(i))) continue;
                                ro = ro != null ? ro : v.toArray();
                                ro[i] = this.dist.nextRandom(this.rnd);
                            }
                            if (ro != null) {
                                o = this.densecols[j].newNumberVector(ro);
                            }
                        }
                        this.rows.add(o);
                    }
                    return ev;
                }
            }
        }
    }

    private void updateMeta(BundleMeta meta) {
        int cols = meta.size();
        this.densecols = new NumberVector.Factory[cols];
        for (int i = 0; i < cols; ++i) {
            if (TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)meta.get(i))) {
                throw new AbortException("Filtering sparse vectors is not yet supported by this filter. Please contribute.");
            }
            if (!TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)meta.get(i))) continue;
            VectorFieldTypeInformation vmeta = (VectorFieldTypeInformation)meta.get(i);
            this.densecols[i] = (NumberVector.Factory)vmeta.getFactory();
        }
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest((CharSequence)"Removing records with NaN values.");
        }
        this.updateMeta(objects.meta());
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int j = 0; j < objects.metaLength(); ++j) {
            bundle.appendColumn(objects.meta(j), new ArrayList());
        }
        for (int i = 0; i < objects.dataLength(); ++i) {
            Object[] row = objects.getRow(i);
            for (int j = 0; j < this.densecols.length; ++j) {
                if (this.densecols[j] == null) continue;
                NumberVector v = (NumberVector)row[j];
                double[] ro = null;
                if (v != null) {
                    for (int d = 0; d < v.getDimensionality(); ++d) {
                        if (!Double.isNaN(v.doubleValue(d))) continue;
                        ro = ro != null ? ro : v.toArray();
                        ro[d] = this.dist.nextRandom(this.rnd);
                    }
                }
                row[j] = this.densecols[j].newNumberVector(ro);
            }
            bundle.appendSimple(row);
        }
        return bundle;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID REPLACEMENT_DISTRIBUTION = new OptionID("nanfilter.replacement", "Distribution to sample replacement values from.");
        public static final OptionID RANDOM_ID = new OptionID("nanfilter.seed", "Random generator seed.");
        private Distribution dist;
        private RandomFactory rnd;

        public void configure(Parameterization config) {
            new ObjectParameter(REPLACEMENT_DISTRIBUTION, Distribution.class).grab(config, x -> {
                this.dist = x;
            });
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public ReplaceNaNWithRandomFilter make() {
            return new ReplaceNaNWithRandomFilter(this.dist, this.rnd);
        }
    }
}

