/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.cleaning;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.data.type.VectorTypeInformation;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.filter.AbstractStreamFilter;
import elki.datasource.filter.FilterUtil;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

public class VectorDimensionalityFilter<V extends NumberVector>
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(VectorDimensionalityFilter.class);
    BundleMeta meta;
    int column = -1;
    int dim = -1;

    public VectorDimensionalityFilter(int dim) {
        this.dim = dim;
    }

    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.updateMeta();
        }
        return this.meta;
    }

    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    this.meta = null;
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (this.meta == null) {
                        this.updateMeta();
                    }
                    if (this.column >= 0 && this.dim >= 0) {
                        NumberVector vec = (NumberVector)this.source.data(this.column);
                        if (vec == null) {
                            if (!LOG.isVeryVerbose()) continue block5;
                            LOG.veryverbose((CharSequence)"Skipping null vector.");
                            continue block5;
                        }
                        if (vec.getDimensionality() != this.dim) {
                            if (!LOG.isVeryVerbose()) continue block5;
                            StringBuilder buf = new StringBuilder(1000).append("Skipping vector of wrong dimensionality ").append(vec.getDimensionality()).append(':');
                            for (int i = 0; i < this.meta.size(); ++i) {
                                buf.append(' ').append(this.source.data(i));
                            }
                            LOG.veryverbose((CharSequence)buf.toString());
                            continue block5;
                        }
                    }
                    return ev;
                }
            }
        }
    }

    private void updateMeta() {
        this.meta = new BundleMeta();
        BundleMeta origmeta = this.source.getMeta();
        for (int i = 0; i < origmeta.size(); ++i) {
            SimpleTypeInformation type = (SimpleTypeInformation)origmeta.get(i);
            if ((this.column < 0 || i == this.column) && TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH.isAssignableFromType((TypeInformation)type)) {
                VectorFieldTypeInformation castType;
                if (type instanceof VectorFieldTypeInformation) {
                    castType = (VectorFieldTypeInformation)type;
                    if (this.dim == -1) {
                        this.dim = castType.mindim();
                    }
                    if (castType.mindim() == this.dim && castType.maxdim() == this.dim) {
                        this.meta.add((Object)castType);
                        this.column = i;
                        continue;
                    }
                }
                castType = (VectorTypeInformation)type;
                if (this.dim == -1) {
                    this.dim = castType.mindim();
                }
                this.meta.add((Object)new VectorFieldTypeInformation(FilterUtil.guessFactory(castType), this.dim, this.dim, castType.getSerializer()));
                this.column = i;
                continue;
            }
            this.meta.add((Object)type);
        }
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID DIM_P = new OptionID("filter.dim", "Dimensionality of vectors to retain.");
        int dim = -1;

        public void configure(Parameterization config) {
            ((IntParameter)((IntParameter)new IntParameter(DIM_P).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.dim = x;
            });
        }

        public VectorDimensionalityFilter<V> make() {
            return new VectorDimensionalityFilter(this.dim);
        }
    }
}

