/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.columnwise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.FilterUtil;
import elki.datasource.filter.normalization.NonNumericFeaturesException;
import elki.datasource.filter.normalization.columnwise.AttributeWiseCDFNormalization;
import elki.logging.Logging;
import elki.math.linearalgebra.LinearEquationSystem;
import elki.math.statistics.distribution.BetaDistribution;
import elki.math.statistics.distribution.Distribution;
import elki.math.statistics.distribution.estimator.DistributionEstimator;
import elki.math.statistics.distribution.estimator.meta.BestFitEstimator;
import elki.utilities.exceptions.NotImplementedException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassListParameter;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jafama.FastMath;

public class AttributeWiseBetaNormalization<V extends NumberVector>
extends AttributeWiseCDFNormalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseBetaNormalization.class);
    protected NumberVector.Factory<V> factory;
    protected double alpha = 0.01;

    public AttributeWiseBetaNormalization(List<? extends DistributionEstimator<?>> estimators, double alpha) {
        super(estimators);
        this.alpha = alpha;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (objects.dataLength() == 0) {
            return objects;
        }
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation type = objects.meta(r);
            List column = objects.getColumn(r);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)type)) continue;
            List castColumn = column;
            VectorFieldTypeInformation castType = (VectorFieldTypeInformation)type;
            this.factory = FilterUtil.guessFactory(castType);
            int dim = castType.getDimensionality();
            this.dists = new ArrayList(dim);
            double[] test = new double[castColumn.size()];
            AttributeWiseCDFNormalization.Adapter adapter = new AttributeWiseCDFNormalization.Adapter();
            for (int d = 0; d < dim; ++d) {
                adapter.dim = d;
                Distribution dist = this.findBestFit(castColumn, adapter, d, test);
                if (LOG.isVerbose()) {
                    LOG.verbose((CharSequence)("Best fit for dimension " + d + ": " + dist.toString()));
                }
                this.dists.add(dist);
            }
            double p = FastMath.pow((double)this.alpha, (double)(-1.0 / Math.sqrt(dim)));
            BetaDistribution beta = new BetaDistribution(p, p);
            double[] buf = new double[dim];
            for (int i = 0; i < objects.dataLength(); ++i) {
                NumberVector obj = (NumberVector)castColumn.get(i);
                for (int d = 0; d < dim; ++d) {
                    buf[d] = beta.quantile(((Distribution)this.dists.get(d)).cdf(obj.doubleValue(d)));
                }
                castColumn.set(i, this.factory.newNumberVector(buf));
            }
        }
        return objects;
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        throw new NotImplementedException();
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        throw new NotImplementedException();
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID DISTRIBUTIONS_ID = AttributeWiseCDFNormalization.Par.DISTRIBUTIONS_ID;
        public static final OptionID ALPHA_ID = new OptionID("normalize.beta.alpha", "Alpha parameter to control the shape of the output distribution.");
        private List<? extends DistributionEstimator<?>> estimators;
        private double alpha;

        public void configure(Parameterization config) {
            ((ClassListParameter)new ObjectListParameter(DISTRIBUTIONS_ID, DistributionEstimator.class).setDefaultValue(Arrays.asList(BestFitEstimator.class))).grab(config, x -> {
                this.estimators = x;
            });
            new DoubleParameter(ALPHA_ID, 0.1).grab(config, x -> {
                this.alpha = x;
            });
        }

        public AttributeWiseBetaNormalization<V> make() {
            return new AttributeWiseBetaNormalization(this.estimators, this.alpha);
        }
    }
}

