/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.columnwise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.FilterUtil;
import elki.datasource.filter.normalization.NonNumericFeaturesException;
import elki.datasource.filter.normalization.Normalization;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.statistics.distribution.NormalDistribution;
import elki.utilities.datastructures.QuickSelect;
import elki.utilities.io.FormatUtil;
import java.util.List;

public class AttributeWiseMADNormalization<V extends NumberVector>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseMADNormalization.class);
    protected NumberVector.Factory<V> factory;
    private double[] median = new double[0];
    private double[] imadsigma = new double[0];

    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (objects.dataLength() == 0) {
            return objects;
        }
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation type = objects.meta(r);
            List column = objects.getColumn(r);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)type)) continue;
            List castColumn = column;
            VectorFieldTypeInformation castType = (VectorFieldTypeInformation)type;
            this.factory = FilterUtil.guessFactory(castType);
            int dim = castType.getDimensionality();
            this.median = new double[dim];
            this.imadsigma = new double[dim];
            double[] test = new double[castColumn.size()];
            FiniteProgress dprog = LOG.isVerbose() ? new FiniteProgress("Analyzing data", dim, LOG) : null;
            for (int d = 0; d < dim; ++d) {
                double med;
                for (int i = 0; i < test.length; ++i) {
                    test[i] = ((NumberVector)castColumn.get(i)).doubleValue(d);
                }
                this.median[d] = med = QuickSelect.median((double[])test);
                int zeros = 0;
                for (int i = 0; i < test.length; ++i) {
                    test[i] = Math.abs(test[i] - med);
                    if (test[i] != 0.0) continue;
                    ++zeros;
                }
                if (zeros < test.length >>> 1) {
                    this.imadsigma[d] = 0.6744897501960817 / QuickSelect.median((double[])test);
                } else if (zeros == test.length) {
                    LOG.warning((CharSequence)"Constant attribute detected. Using MAD=1.");
                    this.imadsigma[d] = 1.0;
                } else {
                    int rank = zeros + (test.length - zeros >> 1);
                    double rel = 0.5 + (double)rank * 0.5 / (double)test.length;
                    this.imadsigma[d] = NormalDistribution.quantile((double)0.0, (double)1.0, (double)rel) / QuickSelect.quickSelect((double[])test, (int)rank);
                    LOG.warning((CharSequence)"Near-constant attribute detected. Using modified MAD.");
                }
                LOG.incrementProcessed((AbstractProgress)dprog);
            }
            LOG.ensureCompleted(dprog);
            FiniteProgress nprog = LOG.isVerbose() ? new FiniteProgress("Data normalization", objects.dataLength(), LOG) : null;
            double[] buf = new double[dim];
            for (int i = 0; i < objects.dataLength(); ++i) {
                NumberVector obj = (NumberVector)castColumn.get(i);
                for (int d = 0; d < dim; ++d) {
                    buf[d] = this.normalize(d, obj.doubleValue(d));
                }
                castColumn.set(i, this.factory.newNumberVector(buf));
                LOG.incrementProcessed((AbstractProgress)nprog);
            }
            LOG.ensureCompleted(nprog);
        }
        return objects;
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        if (featureVector.getDimensionality() != this.median.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + featureVector.getDimensionality() + " former dimensionality: " + this.median.length);
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = this.restore(d, featureVector.doubleValue(d));
        }
        return (V)this.factory.newNumberVector(values);
    }

    private double normalize(int d, double val) {
        return (val - this.median[d]) * this.imadsigma[d];
    }

    private double restore(int d, double val) {
        return val / this.imadsigma[d] + this.median[d];
    }

    public String toString() {
        return new StringBuilder(1000).append("normalization class: ").append(this.getClass().getName()).append('\n').append("normalization median: ").append(FormatUtil.format((double[])this.median)).append('\n').append("normalization scaling factor: ").append(FormatUtil.format((double[])this.imadsigma)).toString();
    }
}

