/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.columnwise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorConversionFilter;
import elki.datasource.filter.normalization.NonNumericFeaturesException;
import elki.datasource.filter.normalization.Normalization;
import elki.logging.Logging;
import elki.math.linearalgebra.LinearEquationSystem;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleListParameter;
import elki.utilities.optionhandling.parameters.Parameter;

@Priority(value=200)
@Alias(value={"norm", "normalize", "minmax"})
public class AttributeWiseMinMaxNormalization<V extends NumberVector>
extends AbstractVectorConversionFilter<V, V>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseMinMaxNormalization.class);
    private double[] maxima;
    private double[] minima;
    private static final double[] EMPTY_ARRAY = new double[0];

    public AttributeWiseMinMaxNormalization() {
        this(EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public AttributeWiseMinMaxNormalization(double[] minima, double[] maxima) {
        this.minima = minima != null ? minima : EMPTY_ARRAY;
        this.maxima = maxima != null ? maxima : EMPTY_ARRAY;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> in) {
        return this.minima.length == 0 || this.maxima.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V featureVector) {
        if (this.minima.length == 0 || this.maxima.length == 0) {
            int dimensionality = featureVector.getDimensionality();
            this.minima = new double[dimensionality];
            this.maxima = new double[dimensionality];
            for (int i = 0; i < dimensionality; ++i) {
                this.maxima[i] = -1.7976931348623157E308;
                this.minima[i] = Double.MAX_VALUE;
            }
        }
        if (this.minima.length != featureVector.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors differ in length.");
        }
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            double val = featureVector.doubleValue(d);
            if (val < Double.POSITIVE_INFINITY && val > this.maxima[d]) {
                this.maxima[d] = val;
            }
            if (!(val > Double.NEGATIVE_INFINITY) || !(val < this.minima[d])) continue;
            this.minima[d] = val;
        }
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        if (this.minima.length != featureVector.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors and given Minima/Maxima differ in length.");
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = (featureVector.doubleValue(d) - this.minima[d]) / this.factor(d);
        }
        return (V)this.factory.newNumberVector(values);
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        if (featureVector.getDimensionality() != this.maxima.length || featureVector.getDimensionality() != this.minima.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + featureVector.getDimensionality() + " former dimensionality: " + this.maxima.length);
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = featureVector.doubleValue(d) * this.factor(d) + this.minima[d];
        }
        return (V)this.factory.newNumberVector(values);
    }

    private double factor(int dimension) {
        return this.maxima[dimension] > this.minima[dimension] ? this.maxima[dimension] - this.minima[dimension] : (this.maxima[dimension] > 0.0 ? this.maxima[dimension] : 1.0);
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] coeff = linearEquationSystem.getCoefficents();
        double[] rhs = linearEquationSystem.getRHS();
        int[] row = linearEquationSystem.getRowPermutations();
        int[] col = linearEquationSystem.getColumnPermutations();
        for (int r = 0; r < coeff.length; ++r) {
            double[] coeff_r = coeff[row[r]];
            double sum = 0.0;
            for (int c = 0; c < coeff_r.length; ++c) {
                int n = col[c];
                double d = coeff_r[n] / this.factor(c);
                coeff_r[n] = d;
                sum += this.minima[c] * d;
            }
            int n = row[r];
            rhs[n] = rhs[n] + sum;
        }
        return new LinearEquationSystem(coeff, rhs, row, col);
    }

    @Override
    public String toString() {
        return new StringBuilder(1000).append("normalization class: ").append(this.getClass().getName()).append('\n').append("normalization minima: ").append(FormatUtil.format((double[])this.minima)).append('\n').append("normalization maxima: ").append(FormatUtil.format((double[])this.maxima)).toString();
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    static /* synthetic */ double[] access$000() {
        return EMPTY_ARRAY;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID MINIMA_ID = new OptionID("normalize.min", "a comma separated concatenation of the minimum values in each dimension that are mapped to 0. If no value is specified, the minimum value of the attribute range in this dimension will be taken.");
        public static final OptionID MAXIMA_ID = new OptionID("normalize.max", "a comma separated concatenation of the maximum values in each dimension that are mapped to 1. If no value is specified, the maximum value of the attribute range in this dimension will be taken.");
        private double[] maxima = AttributeWiseMinMaxNormalization.access$000();
        private double[] minima = AttributeWiseMinMaxNormalization.access$000();

        public void configure(Parameterization config) {
            DoubleListParameter minimaP = (DoubleListParameter)new DoubleListParameter(MINIMA_ID).setOptional(true);
            minimaP.grab(config, x -> {
                this.minima = (double[])x.clone();
            });
            DoubleListParameter maximaP = (DoubleListParameter)new DoubleListParameter(MAXIMA_ID).setOptional(!minimaP.isDefined());
            maximaP.grab(config, x -> {
                this.maxima = (double[])x.clone();
            });
            if (this.minima != null && this.maxima != null && this.minima.length != this.maxima.length) {
                config.reportError((ParameterException)new WrongParameterValueException((Parameter)minimaP, "and", (Parameter)maximaP, "must have the same number of values."));
            }
        }

        public AttributeWiseMinMaxNormalization<V> make() {
            return new AttributeWiseMinMaxNormalization(this.minima, this.maxima);
        }
    }
}

