/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.columnwise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorConversionFilter;
import elki.datasource.filter.normalization.NonNumericFeaturesException;
import elki.datasource.filter.normalization.Normalization;
import elki.logging.Logging;
import elki.math.MeanVariance;
import elki.math.linearalgebra.LinearEquationSystem;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleListParameter;
import elki.utilities.optionhandling.parameters.Parameter;

@Alias(value={"z", "standard", "standardize", "standardization"})
@Priority(value=200)
public class AttributeWiseVarianceNormalization<V extends NumberVector>
extends AbstractVectorConversionFilter<V, V>
implements Normalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseVarianceNormalization.class);
    private double[] mean;
    private double[] stddev;
    MeanVariance[] mvs = null;

    public AttributeWiseVarianceNormalization() {
    }

    public AttributeWiseVarianceNormalization(double[] mean, double[] stddev) {
        this.mean = mean;
        this.stddev = stddev;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> in) {
        return this.mean == null || this.stddev == null || this.mean.length == 0 || this.stddev.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V featureVector) {
        if (this.mvs == null || this.mvs.length == 0) {
            this.mvs = MeanVariance.newArray((int)featureVector.getDimensionality());
        }
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            double v = featureVector.doubleValue(d);
            if (!(v > Double.NEGATIVE_INFINITY) || !(v < Double.POSITIVE_INFINITY)) continue;
            this.mvs[d].put(v);
        }
    }

    @Override
    protected void prepareComplete() {
        StringBuilder buf = LOG.isVerbose() ? new StringBuilder(300) : null;
        int dimensionality = this.mvs.length;
        this.mean = new double[dimensionality];
        this.stddev = new double[dimensionality];
        if (buf != null) {
            buf.append("Normalization parameters: ");
        }
        for (int d = 0; d < dimensionality; ++d) {
            this.mean[d] = this.mvs[d].getMean();
            this.stddev[d] = this.mvs[d].getPopulationStddev();
            double d2 = this.stddev[d] = this.stddev[d] > Double.MIN_NORMAL ? this.stddev[d] : 1.0;
            if (buf == null) continue;
            buf.append(" m: ").append(this.mean[d]).append(" v: ").append(this.stddev[d]);
        }
        this.mvs = null;
        if (buf != null) {
            LOG.debugFine((CharSequence)buf.toString());
        }
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = this.normalize(d, featureVector.doubleValue(d));
        }
        return (V)this.factory.newNumberVector(values);
    }

    @Override
    public V restore(V featureVector) throws NonNumericFeaturesException {
        if (featureVector.getDimensionality() != this.mean.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + featureVector.getDimensionality() + " former dimensionality: " + this.mean.length);
        }
        double[] values = new double[featureVector.getDimensionality()];
        for (int d = 0; d < featureVector.getDimensionality(); ++d) {
            values[d] = this.restore(d, featureVector.doubleValue(d));
        }
        return (V)this.factory.newNumberVector(values);
    }

    private double normalize(int d, double val) {
        d = this.mean.length == 1 ? 0 : d;
        return (val - this.mean[d]) / this.stddev[d];
    }

    private double restore(int d, double val) {
        d = this.mean.length == 1 ? 0 : d;
        return val * this.stddev[d] + this.mean[d];
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] coeff = linearEquationSystem.getCoefficents();
        double[] rhs = linearEquationSystem.getRHS();
        int[] row = linearEquationSystem.getRowPermutations();
        int[] col = linearEquationSystem.getColumnPermutations();
        for (int r = 0; r < coeff.length; ++r) {
            double[] coeff_r = coeff[row[r]];
            double sum = 0.0;
            for (int c = 0; c < coeff_r.length; ++c) {
                int n = col[c];
                double d = coeff_r[n] / this.stddev[c];
                coeff_r[n] = d;
                sum += this.mean[c] * d;
            }
            int n = row[r];
            rhs[n] = rhs[n] + sum;
        }
        return new LinearEquationSystem(coeff, rhs, row, col);
    }

    @Override
    public String toString() {
        return new StringBuilder(200).append("normalization class: ").append(this.getClass().getName()).append('\n').append("normalization means: ").append(FormatUtil.format((double[])this.mean)).append('\n').append("normalization stddevs: ").append(FormatUtil.format((double[])this.stddev)).toString();
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID MEAN_ID = new OptionID("normalize.mean", "a comma separated concatenation of the mean values in each dimension that are mapped to 0. If no value is specified, the mean value of the attribute range in this dimension will be taken.");
        public static final OptionID STDDEV_ID = new OptionID("normalize.stddev", "a comma separated concatenation of the standard deviations in each dimension that are scaled to 1. If no value is specified, the standard deviation of the attribute range in this dimension will be taken.");
        private double[] mean = new double[0];
        private double[] stddev = new double[0];

        public void configure(Parameterization config) {
            DoubleListParameter meanP = (DoubleListParameter)new DoubleListParameter(MEAN_ID).setOptional(true);
            meanP.grab(config, x -> {
                this.mean = (double[])x.clone();
            });
            DoubleListParameter stddevP = (DoubleListParameter)new DoubleListParameter(STDDEV_ID).setOptional(!meanP.isDefined());
            stddevP.grab(config, x -> {
                for (double d : this.stddev = (double[])x.clone()) {
                    if (d != 0.0) continue;
                    config.reportError((ParameterException)new WrongParameterValueException((Parameter)stddevP, stddevP.getValueAsString(), "Standard deviations must not be 0."));
                }
            });
            if (this.mean != null && this.stddev != null && this.mean.length != this.stddev.length) {
                config.reportError((ParameterException)new WrongParameterValueException((Parameter)meanP, "and", (Parameter)stddevP, "must have the same number of values."));
            }
        }

        public AttributeWiseVarianceNormalization<V> make() {
            return new AttributeWiseVarianceNormalization(this.mean, this.stddev);
        }
    }
}

