/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.columnwise;

import elki.data.FeatureVector;
import elki.data.IntegerVector;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.ArrayList;
import java.util.List;

public class IntegerRankTieNormalization
implements ObjectFilter {
    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        int len = objects.dataLength();
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        int[] order = new int[len];
        for (int i = 0; i < len; ++i) {
            order[i] = i;
        }
        Sorter comparator = new Sorter();
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation type = objects.meta(r);
            List column = objects.getColumn(r);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType((TypeInformation)type)) {
                bundle.appendColumn(type, column);
                continue;
            }
            List castColumn = column;
            int dim = ((VectorFieldTypeInformation)type).getDimensionality();
            VectorFieldTypeInformation outType = new VectorFieldTypeInformation((FeatureVector.Factory)IntegerVector.STATIC, dim);
            int[][] posvecs = new int[len][dim];
            for (int d = 0; d < dim; ++d) {
                comparator.setup(castColumn, d);
                IntegerArrayQuickSort.sort((int[])order, (IntComparator)comparator);
                int sta = 0;
                while (sta < order.length) {
                    int end;
                    double v = ((NumberVector)castColumn.get(order[sta])).doubleValue(d);
                    for (end = sta + 1; end < order.length && !(v < ((NumberVector)castColumn.get(order[end])).doubleValue(d)); ++end) {
                    }
                    int pos = sta + end - 1;
                    for (int i = sta; i < end; ++i) {
                        posvecs[order[i]][d] = pos;
                    }
                    sta = end;
                }
            }
            ArrayList<IntegerVector> outColumn = new ArrayList<IntegerVector>(len);
            for (int i = 0; i < len; ++i) {
                outColumn.add(new IntegerVector(posvecs[i]));
            }
            bundle.appendColumn((SimpleTypeInformation)outType, outColumn);
        }
        return bundle;
    }

    private static class Sorter
    implements IntComparator {
        List<? extends NumberVector> col;
        int dim;

        private Sorter() {
        }

        public void setup(List<? extends NumberVector> col, int dim) {
            this.col = col;
            this.dim = dim;
        }

        public int compare(int x, int y) {
            double vy;
            double vx = this.col.get(x).doubleValue(this.dim);
            return vx < (vy = this.col.get(y).doubleValue(this.dim)) ? -1 : (vx == vy ? 0 : 1);
        }
    }
}

