/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.instancewise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.datasource.filter.normalization.Normalization;
import elki.math.MathUtil;
import elki.utilities.optionhandling.Parameterizer;

public class HellingerHistogramNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    public static final HellingerHistogramNormalization<NumberVector> STATIC = new HellingerHistogramNormalization();

    @Override
    protected V filterSingleObject(V featureVector) {
        double v;
        int d;
        double[] data = new double[featureVector.getDimensionality()];
        double sum = 0.0;
        for (d = 0; d < data.length; ++d) {
            v = featureVector.doubleValue(d);
            data[d] = v > 0.0 ? v : -v;
            sum += data[d];
        }
        if (sum > 0.0) {
            for (d = 0; d < data.length; ++d) {
                v = data[d];
                data[d] = v > 0.0 ? Math.sqrt(v / sum) * MathUtil.SQRTHALF : 0.0;
            }
        }
        return (V)this.factory.newNumberVector(data);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Par
    implements Parameterizer {
        public HellingerHistogramNormalization<NumberVector> make() {
            return STATIC;
        }
    }
}

