/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.instancewise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.datasource.filter.normalization.Normalization;
import elki.math.MathUtil;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Arrays;
import net.jafama.FastMath;

public class InstanceLogRankNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    private static final double CENTER = FastMath.log1p((double)0.5) * MathUtil.ONE_BY_LOG2;

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] raw = featureVector.toArray();
        double[] tmp = (double[])raw.clone();
        Arrays.sort(tmp);
        double scale = 0.5 / (double)(raw.length - 1);
        for (int i = 0; i < raw.length; ++i) {
            int first;
            double v = raw[i];
            if (v != v) {
                raw[i] = CENTER;
                continue;
            }
            int last = first + 1;
            assert (first >= 0);
            for (first = Arrays.binarySearch(tmp, v); first > 0 && tmp[first - 1] >= v; --first) {
            }
            while (last < tmp.length && tmp[last] <= v) {
                ++last;
            }
            raw[i] = FastMath.log1p((double)((double)(first + last - 1) * scale)) * MathUtil.ONE_BY_LOG2;
        }
        return (V)this.factory.newNumberVector(raw);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Par
    implements Parameterizer {
        public InstanceLogRankNormalization<NumberVector> make() {
            return new InstanceLogRankNormalization<NumberVector>();
        }
    }
}

