/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.instancewise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorTypeInformation;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.datasource.filter.normalization.Normalization;
import elki.utilities.optionhandling.Parameterizer;

public class InstanceMeanVarianceNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    private int multiplicity;

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] raw = featureVector.toArray();
        if (raw.length == 0) {
            return (V)this.factory.newNumberVector(new double[0]);
        }
        if (raw.length == 1) {
            return (V)this.factory.newNumberVector(new double[]{raw[0] == raw[0] ? 0.0 : Double.NaN});
        }
        if (this.multiplicity > 1) {
            assert (raw.length % this.multiplicity == 0) : "Vector length is not divisible by multiplicity?";
            return (V)this.factory.newNumberVector(this.multivariateStandardization(raw));
        }
        return (V)this.factory.newNumberVector(this.univariateStandardization(raw));
    }

    protected double[] univariateStandardization(double[] raw) {
        double istd;
        double sum = 0.0;
        for (int i = 0; i < raw.length; ++i) {
            double v = raw[i];
            if (v != v) continue;
            sum += v;
        }
        double mean = sum / (double)raw.length;
        double ssum = 0.0;
        for (int i = 0; i < raw.length; ++i) {
            double v = raw[i] - mean;
            if (v != v) continue;
            ssum += v * v;
        }
        double d = istd = ssum > 0.0 ? Math.sqrt((double)raw.length / ssum) : Double.POSITIVE_INFINITY;
        if (istd < Double.POSITIVE_INFINITY) {
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = (raw[i] - mean) * istd;
            }
        }
        return raw;
    }

    protected double[] multivariateStandardization(double[] raw) {
        int i;
        int len = raw.length / this.multiplicity;
        if (len <= 1) {
            return raw;
        }
        double[] mean = new double[this.multiplicity];
        int j = 0;
        for (int i2 = 0; i2 < raw.length; ++i2) {
            double v = raw[i2];
            if (v == v) {
                int n = j;
                mean[n] = mean[n] + v;
            }
            j = ++j == this.multiplicity ? 0 : j;
        }
        int j2 = 0;
        while (j2 < this.multiplicity) {
            int n = j2++;
            mean[n] = mean[n] * ((double)this.multiplicity / (double)len);
        }
        double[] istd = new double[this.multiplicity];
        int j3 = 0;
        for (i = 0; i < raw.length; ++i) {
            double v = raw[i] - mean[j3];
            if (v == v) {
                int n = j3;
                istd[n] = istd[n] + v * v;
            }
            j3 = ++j3 == this.multiplicity ? 0 : j3;
        }
        for (j = 0; j < this.multiplicity; ++j) {
            istd[j] = istd[j] > 0.0 ? Math.sqrt((double)len / istd[j]) : 1.0;
        }
        j3 = 0;
        for (i = 0; i < raw.length; ++i) {
            raw[i] = (raw[i] - mean[j3]) * istd[j3];
            j3 = ++j3 == this.multiplicity ? 0 : j3;
        }
        return raw;
    }

    @Override
    protected void initializeOutputType(SimpleTypeInformation<V> type) {
        super.initializeOutputType(type);
        this.multiplicity = ((VectorTypeInformation)type).getMultiplicity();
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public InstanceMeanVarianceNormalization<V> make() {
            return new InstanceMeanVarianceNormalization();
        }
    }
}

