/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.instancewise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorTypeInformation;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.datasource.filter.normalization.Normalization;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Parameter;

public class InstanceMinMaxNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    private double min;
    private double max;
    private int multiplicity;

    public InstanceMinMaxNormalization(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public InstanceMinMaxNormalization() {
        this(0.0, 1.0);
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] raw = featureVector.toArray();
        if (this.multiplicity > 1) {
            int i;
            assert (raw.length % this.multiplicity == 0) : "Vector length is not divisible by multiplicity?";
            double[] mi = new double[this.multiplicity];
            double[] ma = new double[this.multiplicity];
            for (i = 0; i < this.multiplicity; ++i) {
                mi[i] = Double.POSITIVE_INFINITY;
                ma[i] = Double.NEGATIVE_INFINITY;
            }
            i = 0;
            int j = 0;
            while (i < raw.length) {
                double v = raw[i];
                if (v == v) {
                    mi[j] = mi[j] < v ? mi[j] : v;
                    ma[j] = ma[j] > v ? ma[j] : v;
                }
                ++i;
                ++j;
                j %= this.multiplicity;
            }
            for (int j2 = 0; j2 < this.multiplicity; ++j2) {
                if (!(mi[j2] < ma[j2])) continue;
                double s = (this.max - this.min) / (ma[j2] - mi[j2]);
                for (int i2 = 0; i2 < raw.length; i2 += this.multiplicity) {
                    raw[i2] = (raw[i2] - mi[j2]) * s + this.min;
                }
            }
            return (V)this.factory.newNumberVector(raw);
        }
        double mi = Double.POSITIVE_INFINITY;
        double ma = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < raw.length; ++i) {
            double v = raw[i];
            if (v != v) continue;
            mi = mi < v ? mi : v;
            ma = ma > v ? ma : v;
        }
        if (mi < ma) {
            double s = (this.max - this.min) / (ma - mi);
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = (raw[i] - mi) * s + this.min;
            }
        }
        return (V)this.factory.newNumberVector(raw);
    }

    @Override
    protected void initializeOutputType(SimpleTypeInformation<V> type) {
        super.initializeOutputType(type);
        this.multiplicity = ((VectorTypeInformation)type).getMultiplicity();
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID MIN_ID = new OptionID("normalization.min", "Minimum value to assign to objects.");
        public static final OptionID MAX_ID = new OptionID("normalization.max", "Maximum value to assign to objects.");
        private double min;
        private double max;

        public void configure(Parameterization config) {
            DoubleParameter minP = new DoubleParameter(MIN_ID, 0.0);
            minP.grab(config, x -> {
                this.min = x;
            });
            DoubleParameter maxP = new DoubleParameter(MAX_ID, 1.0);
            maxP.grab(config, x -> {
                this.max = x;
            });
            if (this.min >= this.max) {
                config.reportError((ParameterException)new WrongParameterValueException((Parameter)minP, "must be less than", (Parameter)maxP, ""));
            }
        }

        public InstanceMinMaxNormalization<V> make() {
            return new InstanceMinMaxNormalization(this.min, this.max);
        }
    }
}

