/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.instancewise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.datasource.filter.normalization.Normalization;
import elki.utilities.optionhandling.Parameterizer;
import java.util.Arrays;

public class InstanceRankNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    @Override
    protected V filterSingleObject(V featureVector) {
        double[] raw = featureVector.toArray();
        double[] tmp = (double[])raw.clone();
        Arrays.sort(tmp);
        double scale = 0.5 / (double)(raw.length - 1);
        for (int i = 0; i < raw.length; ++i) {
            int first;
            double v = raw[i];
            if (v != v) {
                raw[i] = 0.5;
                continue;
            }
            int last = first + 1;
            assert (first >= 0);
            for (first = Arrays.binarySearch(tmp, v); first > 0 && tmp[first - 1] >= v; --first) {
            }
            while (last < tmp.length && tmp[last] <= v) {
                ++last;
            }
            raw[i] = (double)(first + last - 1) * scale;
        }
        return (V)this.factory.newNumberVector(raw);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Par
    implements Parameterizer {
        public InstanceRankNormalization<NumberVector> make() {
            return new InstanceRankNormalization<NumberVector>();
        }
    }
}

