/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.instancewise;

import elki.data.NumberVector;
import elki.data.SparseNumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.datasource.filter.normalization.Normalization;
import elki.distance.Norm;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.ManhattanDistance;
import elki.distance.minkowski.SparseEuclideanDistance;
import elki.distance.minkowski.SparseManhattanDistance;
import elki.math.linearalgebra.VMath;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;

public class LengthNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    Norm<? super V> norm;
    Int2DoubleOpenHashMap map;

    public LengthNormalization(Norm<? super V> norm) {
        this.norm = norm;
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double d;
        double factor;
        SparseEuclideanDistance norm = this.norm;
        if (featureVector instanceof SparseNumberVector) {
            if (EuclideanDistance.STATIC.equals(norm)) {
                norm = SparseEuclideanDistance.STATIC;
            } else if (ManhattanDistance.STATIC.equals((Object)norm)) {
                norm = SparseManhattanDistance.STATIC;
            }
        }
        double d2 = factor = (d = norm.norm(featureVector)) > 0.0 ? 1.0 / d : 1.0;
        if (featureVector instanceof SparseNumberVector && this.factory instanceof SparseNumberVector.Factory) {
            SparseNumberVector fv = (SparseNumberVector)featureVector;
            SparseNumberVector.Factory sfact = (SparseNumberVector.Factory)this.factory;
            if (this.map == null) {
                this.map = new Int2DoubleOpenHashMap();
            }
            this.map.clear();
            int j = fv.iter();
            while (fv.iterValid(j)) {
                this.map.put(fv.iterDim(j), fv.iterDoubleValue(j) * factor);
                j = fv.iterAdvance(j);
            }
            return (V)sfact.newNumberVector(this.map, fv.getDimensionality());
        }
        return (V)this.factory.newNumberVector(VMath.timesEquals((double[])featureVector.toArray(), (double)factor));
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID NORM_ID = new OptionID("normalization.norm", "Norm (length function) to use for computing the vector length.");
        Norm<? super V> norm;

        public void configure(Parameterization config) {
            new ObjectParameter(NORM_ID, Norm.class, EuclideanDistance.class).grab(config, x -> {
                this.norm = x;
            });
        }

        public LengthNormalization<V> make() {
            return new LengthNormalization<V>(this.norm);
        }
    }
}

