/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.normalization.instancewise;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.datasource.filter.normalization.Normalization;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

public class Log1PlusNormalization<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V>
implements Normalization<V> {
    public static final Log1PlusNormalization<NumberVector> STATIC = new Log1PlusNormalization(1.0);
    protected double boost;
    protected double scale;

    public Log1PlusNormalization(double boost) {
        this.boost = boost;
        this.scale = 1.0 / FastMath.log1p((double)boost);
    }

    @Override
    protected V filterSingleObject(V featureVector) {
        double[] data = new double[featureVector.getDimensionality()];
        for (int d = 0; d < data.length; ++d) {
            double v = featureVector.doubleValue(d);
            data[d] = FastMath.log1p((double)((v > 0.0 ? v : -v) * this.boost)) * this.scale;
        }
        return (V)this.factory.newNumberVector(data);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID BOOST_ID = new OptionID("log1pscale.boost", "Boosting factor. Larger values will yield a steeper curve.");
        protected double boost;

        public void configure(Parameterization config) {
            ((DoubleParameter)new DoubleParameter(BOOST_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.boost = x;
            });
        }

        public Log1PlusNormalization<V> make() {
            return new Log1PlusNormalization(this.boost);
        }
    }
}

