/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.selection;

import elki.data.LabelList;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.filter.AbstractStreamFilter;
import elki.datasource.filter.FilterUtil;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByLabelFilter
extends AbstractStreamFilter {
    private static final Logging LOG = Logging.getLogger(ByLabelFilter.class);
    private final Matcher matcher;
    private final boolean inverted;
    private int lblcol = -1;

    public ByLabelFilter(Pattern pattern, boolean inverted) {
        this.matcher = pattern.matcher("");
        this.inverted = inverted;
    }

    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    if (this.lblcol < 0) {
                        LOG.warning((CharSequence)"By label filter was used, but never saw a label relation!");
                    }
                    return BundleStreamSource.Event.END_OF_STREAM;
                }
                case META_CHANGED: {
                    if (this.lblcol < 0) {
                        BundleMeta meta = this.source.getMeta();
                        this.lblcol = FilterUtil.findLabelColumn(meta);
                    }
                    return BundleStreamSource.Event.META_CHANGED;
                }
                case NEXT_OBJECT: {
                    if (this.lblcol > 0) {
                        Object l = this.source.data(this.lblcol);
                        if (l instanceof LabelList) {
                            boolean good = false;
                            LabelList ll = (LabelList)l;
                            for (int i = 0; i < ll.size(); ++i) {
                                this.matcher.reset(ll.get(i));
                                if (!this.matcher.matches()) continue;
                                good = true;
                                break;
                            }
                            if (good == this.inverted) {
                                continue block5;
                            }
                        } else {
                            this.matcher.reset(l.toString());
                            if (!this.matcher.matches()) {
                                continue block5;
                            }
                        }
                    } else if (!this.inverted) continue block5;
                    return BundleStreamSource.Event.NEXT_OBJECT;
                }
            }
            LOG.warning((CharSequence)("Unknown event: " + ev));
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID LABELFILTER_PATTERN_ID = new OptionID("patternfilter.pattern", "The filter pattern to use.");
        public static final OptionID LABELFILTER_PATTERN_INVERT_ID = new OptionID("patternfilter.invert", "Flag to invert pattern.");
        Pattern pattern = null;
        private boolean inverted = false;

        public void configure(Parameterization config) {
            new PatternParameter(LABELFILTER_PATTERN_ID).grab(config, x -> {
                this.pattern = x;
            });
            new Flag(LABELFILTER_PATTERN_INVERT_ID).grab(config, x -> {
                this.inverted = x;
            });
        }

        public ByLabelFilter make() {
            return new ByLabelFilter(this.pattern, this.inverted);
        }
    }
}

