/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.selection;

import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.filter.AbstractStreamFilter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

public class FirstNStreamFilter
extends AbstractStreamFilter {
    protected int n;

    public FirstNStreamFilter(int n) {
        this.n = n;
    }

    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    public BundleStreamSource.Event nextEvent() {
        while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (this.n == 0) {
                        return BundleStreamSource.Event.END_OF_STREAM;
                    }
                    --this.n;
                    return ev;
                }
            }
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID SIZE_ID = new OptionID("first.n", "Number of objects to keep.");
        protected int n;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(SIZE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.n = x;
            });
        }

        public FirstNStreamFilter make() {
            return new FirstNStreamFilter(this.n);
        }
    }
}

