/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.selection;

import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.filter.AbstractStreamFilter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

public class RandomSamplingStreamFilter
extends AbstractStreamFilter {
    protected double prob;
    protected Random random;

    public RandomSamplingStreamFilter(double prob, RandomFactory rnd) {
        this.prob = prob;
        this.random = rnd.getSingleThreadedRandom();
    }

    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    public Object data(int rnum) {
        return this.source.data(rnum);
    }

    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event ev = this.source.nextEvent();
            switch (ev) {
                case END_OF_STREAM: {
                    return ev;
                }
                case META_CHANGED: {
                    return ev;
                }
                case NEXT_OBJECT: {
                    if (!(this.random.nextDouble() < this.prob)) continue block5;
                    return ev;
                }
            }
        }
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID PROB_ID = new OptionID("sampling.p", "Sampling probability. Each object has a chance of being sampled with this probability.");
        public static final OptionID SEED_ID = new OptionID("sampling.seed", "Random generator seed for sampling.");
        protected double prob;
        protected RandomFactory rnd;

        public void configure(Parameterization config) {
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(PROB_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE)).grab(config, x -> {
                this.prob = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public RandomSamplingStreamFilter make() {
            return new RandomSamplingStreamFilter(this.prob, this.rnd);
        }
    }
}

