/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.selection;

import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.logging.Logging;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ShuffleObjectsFilter
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(ShuffleObjectsFilter.class);
    final RandomFactory rnd;

    public ShuffleObjectsFilter(RandomFactory rnd) {
        this.rnd = rnd;
    }

    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        int j;
        int i;
        if (LOG.isDebugging()) {
            LOG.debug((CharSequence)"Shuffling the data set");
        }
        Random random = this.rnd.getSingleThreadedRandom();
        int size = objects.dataLength();
        int[] offsets = new int[size];
        for (i = 0; i < size; ++i) {
            offsets[i] = i;
        }
        for (i = size; i > 1; --i) {
            j = random.nextInt(i);
            int temp = offsets[j];
            offsets[j] = offsets[i - 1];
            offsets[i - 1] = temp;
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (j = 0; j < objects.metaLength(); ++j) {
            List in = objects.getColumn(j);
            ArrayList data = new ArrayList(size);
            for (int i2 = 0; i2 < size; ++i2) {
                data.add(in.get(offsets[i2]));
            }
            bundle.appendColumn(objects.meta(j), data);
        }
        return bundle;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID SEED_ID = new OptionID("shuffle.seed", "Seed for randomly shuffling the rows for the database. If the parameter is not set, a random seed will be used.");
        RandomFactory rnd;

        public void configure(Parameterization config) {
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public ShuffleObjectsFilter make() {
            return new ShuffleObjectsFilter(this.rnd);
        }
    }
}

