/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.transform;

import elki.data.DoubleVector;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.FilterUtil;
import elki.datasource.filter.ObjectFilter;
import elki.datasource.filter.transform.ClassicMultidimensionalScalingTransform;
import elki.distance.PrimitiveDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.List;
import java.util.Random;

@Alias(value={"fastmds"})
@Priority(value=99)
public class FastMultidimensionalScalingTransform<I, O extends NumberVector>
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(FastMultidimensionalScalingTransform.class);
    PrimitiveDistance<? super I> dist;
    int tdim;
    RandomFactory random;
    NumberVector.Factory<O> factory;

    public FastMultidimensionalScalingTransform(int tdim, PrimitiveDistance<? super I> dist, NumberVector.Factory<O> factory, RandomFactory random) {
        this.tdim = tdim;
        this.dist = dist;
        this.random = random;
        this.factory = factory;
    }

    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        int size = objects.dataLength();
        if (size == 0) {
            return objects;
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation type = objects.meta(r);
            List column = objects.getColumn(r);
            if (!this.dist.getInputTypeRestriction().isAssignableFromType((TypeInformation)type)) {
                bundle.appendColumn(type, column);
                continue;
            }
            List castColumn = column;
            NumberVector.Factory factory = null;
            if (type instanceof VectorFieldTypeInformation) {
                VectorFieldTypeInformation ctype;
                VectorFieldTypeInformation vtype = ctype = (VectorFieldTypeInformation)type;
                factory = FilterUtil.guessFactory(vtype);
            } else {
                factory = DoubleVector.FACTORY;
            }
            bundle.appendColumn((SimpleTypeInformation)new VectorFieldTypeInformation(factory, this.tdim), castColumn);
            double[][] imat = ClassicMultidimensionalScalingTransform.computeSquaredDistanceMatrix(castColumn, this.dist);
            ClassicMultidimensionalScalingTransform.doubleCenterSymmetric(imat);
            double[][] evs = new double[this.tdim][size];
            double[] lambda = new double[this.tdim];
            this.findEigenVectors(imat, evs, lambda);
            if (!this.dist.isSquared()) {
                for (int i = 0; i < this.tdim; ++i) {
                    lambda[i] = Math.sqrt(Math.abs(lambda[i]));
                }
            }
            double[] buf = new double[this.tdim];
            for (int i = 0; i < size; ++i) {
                for (int d = 0; d < this.tdim; ++d) {
                    buf[d] = lambda[d] * evs[d][i];
                }
                column.set(i, factory.newNumberVector(buf));
            }
        }
        return bundle;
    }

    protected void findEigenVectors(double[][] imat, double[][] evs, double[] lambda) {
        int size = imat.length;
        Random rnd = this.random.getSingleThreadedRandom();
        double[] tmp = new double[size];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Learning projections", this.tdim, LOG) : null;
        int d = 0;
        while (d < this.tdim) {
            double delta;
            double[] cur = evs[d];
            this.randomInitialization(cur, rnd);
            double l = this.multiply(imat, cur, tmp);
            for (int iter = 0; iter < 100 && !((delta = this.updateEigenvector(tmp, cur, l)) < 1.0E-10); ++iter) {
                l = this.multiply(imat, cur, tmp);
            }
            lambda[d++] = l = this.estimateEigenvalue(imat, cur);
            LOG.incrementProcessed((AbstractProgress)prog);
            if (d == this.tdim) break;
            this.updateMatrix(imat, cur, l);
        }
        LOG.ensureCompleted(prog);
    }

    protected void randomInitialization(double[] out, Random rnd) {
        double l2 = 0.0;
        while (!(l2 > 0.0)) {
            for (int d = 0; d < out.length; ++d) {
                double val;
                out[d] = val = rnd.nextDouble();
                l2 += val * val;
            }
        }
        double s = 1.0 / Math.sqrt(l2);
        int d = 0;
        while (d < out.length) {
            int n = d++;
            out[n] = out[n] * s;
        }
    }

    protected double multiply(double[][] mat, double[] in, double[] out) {
        double l = 0.0;
        for (int d1 = 0; d1 < in.length; ++d1) {
            double[] row = mat[d1];
            double t = 0.0;
            for (int d2 = 0; d2 < in.length; ++d2) {
                t += row[d2] * in[d2];
            }
            out[d1] = t;
            l += t * t;
        }
        return l > 0.0 ? Math.sqrt(l) : 0.0;
    }

    protected double updateEigenvector(double[] in, double[] out, double l) {
        double s = 1.0 / (l > 0.0 ? l : (l < 0.0 ? -l : 1.0));
        s = in[0] > 0.0 ? s : -s;
        double diff = 0.0;
        for (int d = 0; d < in.length; ++d) {
            int n = d;
            in[n] = in[n] * s;
            double delta = in[d] - out[d];
            diff += delta * delta;
            out[d] = in[d];
        }
        return diff;
    }

    protected double estimateEigenvalue(double[][] mat, double[] in) {
        double de = 0.0;
        double di = 0.0;
        for (int d1 = 0; d1 < in.length; ++d1) {
            double[] row = mat[d1];
            double t = 0.0;
            for (int d2 = 0; d2 < in.length; ++d2) {
                t += row[d2] * in[d2];
            }
            double s = in[d1];
            de += t * s;
            di += s * s;
        }
        return de / di;
    }

    protected void updateMatrix(double[][] mat, double[] evec, double eval) {
        int size = mat.length;
        for (int i = 0; i < size; ++i) {
            double[] mati = mat[i];
            double eveci = evec[i];
            for (int j = 0; j < size; ++j) {
                int n = j;
                mati[n] = mati[n] - eval * eveci * evec[j];
            }
        }
    }

    public static class Par<I, O extends NumberVector>
    implements Parameterizer {
        public static final OptionID RANDOM_ID = new OptionID("mds.seed", "Random seed for fast MDS.");
        int tdim;
        PrimitiveDistance<? super I> dist = null;
        RandomFactory random = RandomFactory.DEFAULT;
        NumberVector.Factory<O> factory;

        public void configure(Parameterization config) {
            new IntParameter(ClassicMultidimensionalScalingTransform.Par.DIM_ID).grab(config, x -> {
                this.tdim = x;
            });
            new ObjectParameter(ClassicMultidimensionalScalingTransform.Par.DISTANCE_ID, PrimitiveDistance.class, SquaredEuclideanDistance.class).grab(config, x -> {
                this.dist = x;
            });
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.random = x;
            });
            new ObjectParameter(ClassicMultidimensionalScalingTransform.Par.VECTOR_TYPE_ID, NumberVector.Factory.class, DoubleVector.Factory.class).grab(config, x -> {
                this.factory = x;
            });
        }

        public FastMultidimensionalScalingTransform<I, O> make() {
            return new FastMultidimensionalScalingTransform<I, O>(this.tdim, this.dist, this.factory, this.random);
        }
    }
}

