/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.transform;

import elki.data.FeatureVector;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.filter.AbstractVectorConversionFilter;
import elki.logging.Logging;
import elki.math.linearalgebra.CovarianceMatrix;
import elki.math.linearalgebra.VMath;
import elki.math.linearalgebra.pca.EigenPair;
import elki.math.linearalgebra.pca.PCAResult;
import elki.math.linearalgebra.pca.PCARunner;
import elki.math.linearalgebra.pca.filter.EigenPairFilter;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Alias(value={"whiten", "whitening", "pca"})
@Priority(value=200)
public class GlobalPrincipalComponentAnalysisTransform<O extends NumberVector>
extends AbstractVectorConversionFilter<O, O> {
    private static final Logging LOG = Logging.getLogger(GlobalPrincipalComponentAnalysisTransform.class);
    EigenPairFilter filter = null;
    CovarianceMatrix covmat = null;
    double[][] proj = null;
    double[] buf = null;
    double[] mean = null;
    Mode mode;

    public GlobalPrincipalComponentAnalysisTransform(EigenPairFilter filter) {
        this(filter, Mode.FULL);
    }

    public GlobalPrincipalComponentAnalysisTransform(EigenPairFilter filter, Mode mode) {
        this.filter = filter;
        this.mode = mode;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<O> in) {
        if (!(in instanceof VectorFieldTypeInformation)) {
            throw new AbortException("PCA can only applied to fixed dimensionality vectors");
        }
        int dim = ((VectorFieldTypeInformation)in).getDimensionality();
        this.covmat = new CovarianceMatrix(dim);
        this.proj = null;
        this.mean = null;
        return true;
    }

    @Override
    protected void prepareProcessInstance(O obj) {
        this.covmat.put(obj);
    }

    @Override
    protected void prepareComplete() {
        int pdim;
        this.mean = this.covmat.getMeanVector();
        PCAResult pcares = new PCARunner(null).processCovarMatrix(this.covmat.destroyToPopulationMatrix());
        this.covmat = null;
        int dim = this.mean.length;
        int n = pdim = this.filter != null ? this.filter.filter(pcares.getEigenvalues()) : dim;
        if (this.filter != null && LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Reducing dimensionality from " + dim + " to " + pdim + " via PCA."));
        }
        this.proj = new double[pdim][dim];
        for (int d = 0; d < pdim; ++d) {
            EigenPair ep = pcares.getEigenPairs()[d];
            VMath.plusTimesEquals((double[])this.proj[d], (double[])ep.getEigenvector(), (double)(this.mode == Mode.FULL ? 1.0 / Math.sqrt(ep.getEigenvalue()) : 1.0));
        }
        this.buf = new double[dim];
    }

    @Override
    protected O filterSingleObject(O obj) {
        for (int i = 0; i < this.mean.length; ++i) {
            this.buf[i] = obj.doubleValue(i) - this.mean[i];
        }
        return (O)this.factory.newNumberVector(VMath.times((double[][])this.proj, (double[])this.buf));
    }

    @Override
    protected SimpleTypeInformation<? super O> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<O> in) {
        this.initializeOutputType(in);
        return new VectorFieldTypeInformation((FeatureVector.Factory)this.factory, this.proj.length);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O extends NumberVector>
    implements Parameterizer {
        public static final OptionID FILTER_ID = new OptionID("globalpca.filter", "Filter to use for dimensionality reduction.");
        public static final OptionID MODE_ID = new OptionID("globalpca.mode", "Operation mode: full, or rotate only.");
        EigenPairFilter filter = null;
        Mode mode;

        public void configure(Parameterization config) {
            new ObjectParameter(FILTER_ID, EigenPairFilter.class).setOptional(true).grab(config, x -> {
                this.filter = x;
            });
            new EnumParameter(MODE_ID, Mode.class, (Enum)Mode.FULL).grab(config, x -> {
                this.mode = x;
            });
        }

        public GlobalPrincipalComponentAnalysisTransform<O> make() {
            return new GlobalPrincipalComponentAnalysisTransform(this.filter, this.mode);
        }
    }

    public static enum Mode {
        FULL,
        CENTER_ROTATE;

    }
}

