/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.transform;

import elki.data.DoubleVector;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.math.statistics.distribution.Distribution;
import elki.math.statistics.distribution.ExponentialDistribution;
import elki.utilities.documentation.Description;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Description(value="Add uniform Jitter to a dataset, while preserving the total vector sum.")
public class HistogramJitterFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    double jitter;
    Distribution dist;
    Random rnd;

    public HistogramJitterFilter(double jitter, RandomFactory rnd) {
        this.jitter = jitter;
        this.dist = new ExponentialDistribution(1.0);
        this.rnd = rnd.getSingleThreadedRandom();
    }

    @Override
    protected V filterSingleObject(V obj) {
        int dim = obj.getDimensionality();
        double osum = 0.0;
        for (int i = 0; i < dim; ++i) {
            osum += obj.doubleValue(i);
        }
        double maxjitter = 2.0 * this.jitter / (double)dim * osum;
        double[] raw = new double[dim];
        double jsum = 0.0;
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = this.dist.nextRandom(this.rnd) * maxjitter;
            jsum += raw[i];
        }
        double mix = jsum / osum;
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = raw[i] + (1.0 - mix) * obj.doubleValue(i);
        }
        return (V)this.factory.newNumberVector(raw);
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    protected SimpleTypeInformation<V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return in;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID JITTER_ID = new OptionID("jitter.amount", "Jitter amount relative to data.");
        public static final OptionID SEED_ID = new OptionID("jitter.seed", "Jitter random seed.");
        double jitter = 0.1;
        RandomFactory rnd;

        public void configure(Parameterization config) {
            ((DoubleParameter)new DoubleParameter(JITTER_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.jitter = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public HistogramJitterFilter<DoubleVector> make() {
            return new HistogramJitterFilter<DoubleVector>(this.jitter, this.rnd);
        }
    }
}

