/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.transform;

import elki.data.DoubleVector;
import elki.data.FeatureVector;
import elki.data.NumberVector;
import elki.data.VectorUtil;
import elki.data.projection.FeatureSelection;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntListParameter;

public class NumberVectorFeatureSelectionFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    private long[] selectedAttributes;

    public NumberVectorFeatureSelectionFilter(long[] selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    @Override
    protected V filterSingleObject(V obj) {
        return (V)VectorUtil.project(obj, (long[])this.getSelectedAttributes(), (NumberVector.Factory)this.factory);
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeOutputType(in);
        return new VectorFieldTypeInformation((FeatureVector.Factory)this.factory, this.getDimensionality());
    }

    public void setSelectedAttributes(long[] selectedAttributes) {
        this.selectedAttributes = selectedAttributes;
    }

    public long[] getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public int getDimensionality() {
        return BitsUtil.cardinality((long[])this.selectedAttributes);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID SELECTED_ATTRIBUTES_ID = FeatureSelection.Par.SELECTED_ATTRIBUTES_ID;
        protected long[] selectedAttributes;

        public void configure(Parameterization config) {
            ((IntListParameter)new IntListParameter(SELECTED_ATTRIBUTES_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST)).grab(config, x -> {
                this.selectedAttributes = BitsUtil.of((int[])x);
            });
        }

        public NumberVectorFeatureSelectionFilter<DoubleVector> make() {
            return new NumberVectorFeatureSelectionFilter<DoubleVector>(this.selectedAttributes);
        }
    }
}

