/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.transform;

import elki.data.DoubleVector;
import elki.data.FeatureVector;
import elki.data.NumberVector;
import elki.data.VectorUtil;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.filter.AbstractVectorStreamConversionFilter;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

public class NumberVectorRandomFeatureSelectionFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    protected long[] selectedAttributes = null;
    protected int k;
    protected RandomFactory rnd;

    public NumberVectorRandomFeatureSelectionFilter(int dim, RandomFactory rnd) {
        this.k = dim;
        this.rnd = rnd;
    }

    @Override
    protected V filterSingleObject(V obj) {
        return (V)VectorUtil.project(obj, (long[])this.selectedAttributes, (NumberVector.Factory)this.factory);
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        this.initializeRandomAttributes(in);
        this.initializeOutputType(in);
        return new VectorFieldTypeInformation((FeatureVector.Factory)this.factory, this.k);
    }

    void initializeRandomAttributes(SimpleTypeInformation<V> in) {
        int d = ((VectorFieldTypeInformation)in).getDimensionality();
        this.selectedAttributes = BitsUtil.random((int)this.k, (int)d, (Random)this.rnd.getSingleThreadedRandom());
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID NUMBER_SELECTED_ATTRIBUTES_ID = new OptionID("randomprojection.numberselected", "number of selected attributes");
        public static final OptionID SEED_ID = new OptionID("randomprojection.seed", "Seed for random selection of projection attributes.");
        protected int k = 0;
        protected RandomFactory rnd;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(NUMBER_SELECTED_ATTRIBUTES_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new RandomParameter(SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public NumberVectorRandomFeatureSelectionFilter<DoubleVector> make() {
            return new NumberVectorRandomFeatureSelectionFilter<DoubleVector>(this.k, this.rnd);
        }
    }
}

