/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.typeconversions;

import elki.data.ClassLabel;
import elki.data.LabelList;
import elki.data.SimpleClassLabel;
import elki.data.type.SimpleTypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;

public class ClassLabelFilter
implements ObjectFilter {
    private final int classLabelIndex;
    private final ClassLabel.Factory<?> classLabelFactory;

    public ClassLabelFilter(int classLabelIndex, ClassLabel.Factory<?> classLabelFactory) {
        this.classLabelIndex = classLabelIndex;
        this.classLabelFactory = classLabelFactory;
    }

    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        boolean done = false;
        boolean keeplabelcol = false;
        for (int i = 0; i < objects.metaLength(); ++i) {
            SimpleTypeInformation meta = objects.meta(i);
            if (done || !LabelList.class.equals((Object)meta.getRestrictionClass())) {
                bundle.appendColumn(meta, objects.getColumn(i));
                continue;
            }
            done = true;
            ArrayList<ClassLabel> clscol = new ArrayList<ClassLabel>(objects.dataLength());
            ArrayList<LabelList> lblcol = new ArrayList<LabelList>(objects.dataLength());
            ArrayList<String> lbuf = new ArrayList<String>();
            for (Object obj : objects.getColumn(i)) {
                if (obj != null) {
                    LabelList ll = (LabelList)obj;
                    int off = this.classLabelIndex >= 0 ? this.classLabelIndex : ll.size() - this.classLabelIndex;
                    try {
                        ClassLabel lbl = this.classLabelFactory.makeFromString(ll.get(off));
                        clscol.add(lbl);
                    }
                    catch (Exception e) {
                        throw new AbortException("Cannot initialize class labels: " + e.getMessage(), (Throwable)e);
                    }
                    lbuf.clear();
                    for (int j = 0; j < ll.size(); ++j) {
                        if (j == off) continue;
                        lbuf.add(ll.get(j));
                    }
                    lblcol.add(LabelList.make(lbuf));
                    if (lbuf.isEmpty()) continue;
                    keeplabelcol = true;
                    continue;
                }
                clscol.add(null);
                lblcol.add(null);
            }
            bundle.appendColumn(this.classLabelFactory.getTypeInformation(), clscol);
            if (!keeplabelcol) continue;
            bundle.appendColumn(meta, lblcol);
        }
        return bundle;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID CLASS_LABEL_INDEX_ID = new OptionID("dbc.classLabelIndex", "The index of the label to be used as class label. The first label is 0, negative indexes are relative to the end.");
        public static final OptionID CLASS_LABEL_CLASS_ID = new OptionID("dbc.classLabelClass", "Class label class to use.");
        protected int classLabelIndex;
        private ClassLabel.Factory<?> classLabelFactory;

        public void configure(Parameterization config) {
            new IntParameter(CLASS_LABEL_INDEX_ID).grab(config, x -> {
                this.classLabelIndex = x;
            });
            new ObjectParameter(CLASS_LABEL_CLASS_ID, ClassLabel.Factory.class, SimpleClassLabel.Factory.class).grab(config, x -> {
                this.classLabelFactory = x;
            });
        }

        public ClassLabelFilter make() {
            return new ClassLabelFilter(this.classLabelIndex, this.classLabelFactory);
        }
    }
}

