/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.typeconversions;

import elki.data.LabelList;
import elki.data.SimpleClassLabel;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.filter.AbstractStreamFilter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.optionhandling.parameters.StringParameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.regex.Pattern;

public class ClassLabelFromPatternFilter
extends AbstractStreamFilter {
    BundleMeta meta = null;
    IntArrayList labelcols = new IntArrayList();
    SimpleClassLabel positive;
    SimpleClassLabel negative;
    Pattern pattern;

    public ClassLabelFromPatternFilter(Pattern pattern, String positive, String negative) {
        this.pattern = pattern;
        this.positive = new SimpleClassLabel(positive);
        this.negative = new SimpleClassLabel(negative);
    }

    public ClassLabelFromPatternFilter(Pattern pattern, SimpleClassLabel positive, SimpleClassLabel negative) {
        this.pattern = pattern;
        this.positive = positive;
        this.negative = negative;
    }

    public BundleMeta getMeta() {
        if (this.meta == null) {
            BundleMeta origmeta = this.source.getMeta();
            this.meta = new BundleMeta(origmeta.size() + 1);
            this.meta.add((Object)TypeUtil.SIMPLE_CLASSLABEL);
            this.labelcols.clear();
            for (int i = 0; i < origmeta.size(); ++i) {
                SimpleTypeInformation orig = (SimpleTypeInformation)origmeta.get(i);
                if (TypeUtil.GUESSED_LABEL.isAssignableFromType((TypeInformation)orig)) {
                    this.labelcols.add(i);
                }
                this.meta.add((Object)orig);
            }
        }
        return this.meta;
    }

    public Object data(int rnum) {
        if (rnum > 0) {
            return this.source.data(rnum - 1);
        }
        if (this.meta == null) {
            this.getMeta();
        }
        for (int i = 0; i < this.labelcols.size(); ++i) {
            Object o = this.source.data(this.labelcols.getInt(i));
            if (o == null) continue;
            if (o instanceof LabelList) {
                LabelList ll = (LabelList)o;
                for (int j = 0; j < ll.size(); ++j) {
                    if (!this.pattern.matcher(ll.get(j)).find()) continue;
                    return this.positive;
                }
                continue;
            }
            if (!this.pattern.matcher(o.toString()).find()) continue;
            return this.positive;
        }
        return this.negative;
    }

    public BundleStreamSource.Event nextEvent() {
        BundleStreamSource.Event ev = this.source.nextEvent();
        if (BundleStreamSource.Event.META_CHANGED.equals((Object)ev)) {
            this.meta = null;
        }
        return ev;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID PATTERN_ID = new OptionID("class.pattern", "Regular expression to identify positive objects.");
        public static final OptionID POSITIVE_ID = new OptionID("class.positive", "Class label to use for positive instances.");
        public static final OptionID NEGATIVE_ID = new OptionID("class.negative", "Class label to use for negative instances.");
        Pattern pattern;
        String positive;
        String negative;

        public void configure(Parameterization config) {
            new PatternParameter(PATTERN_ID).grab(config, x -> {
                this.pattern = x;
            });
            new StringParameter(POSITIVE_ID, "positive").grab(config, x -> {
                this.positive = x;
            });
            new StringParameter(NEGATIVE_ID, "negative").grab(config, x -> {
                this.negative = x;
            });
        }

        public ClassLabelFromPatternFilter make() {
            return new ClassLabelFromPatternFilter(this.pattern, this.positive, this.negative);
        }
    }
}

