/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.typeconversions;

import elki.data.ExternalID;
import elki.data.LabelList;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.ObjectFilter;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;

public class ExternalIDFilter
implements ObjectFilter {
    private final int externalIdIndex;

    public ExternalIDFilter(int externalIdIndex) {
        this.externalIdIndex = externalIdIndex;
    }

    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        boolean done = false;
        boolean keeplabelcol = false;
        for (int i = 0; i < objects.metaLength(); ++i) {
            SimpleTypeInformation meta = objects.meta(i);
            if (done || !LabelList.class.equals((Object)meta.getRestrictionClass())) {
                bundle.appendColumn(meta, objects.getColumn(i));
                continue;
            }
            done = true;
            ArrayList<ExternalID> eidcol = new ArrayList<ExternalID>(objects.dataLength());
            ArrayList<LabelList> lblcol = new ArrayList<LabelList>(objects.dataLength());
            ArrayList<String> lbuf = new ArrayList<String>();
            for (Object obj : objects.getColumn(i)) {
                if (obj != null) {
                    LabelList ll = (LabelList)obj;
                    int off = this.externalIdIndex >= 0 ? this.externalIdIndex : ll.size() - this.externalIdIndex;
                    eidcol.add(new ExternalID(ll.get(off)));
                    lbuf.clear();
                    for (int j = 0; j < ll.size(); ++j) {
                        if (j == off) continue;
                        lbuf.add(ll.get(j));
                    }
                    lblcol.add(LabelList.make(lbuf));
                    if (ll.size() <= 0) continue;
                    keeplabelcol = true;
                    continue;
                }
                eidcol.add(null);
                lblcol.add(null);
            }
            bundle.appendColumn(TypeUtil.EXTERNALID, eidcol);
            if (!keeplabelcol) continue;
            bundle.appendColumn(meta, lblcol);
        }
        return bundle;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID EXTERNALID_INDEX_ID = new OptionID("dbc.externalIdIndex", "The index of the label to be used as external Id. The first label is 0; negative indexes are relative to the end.");
        int externalIdIndex = -1;

        public void configure(Parameterization config) {
            new IntParameter(EXTERNALID_INDEX_ID).grab(config, x -> {
                this.externalIdIndex = x;
            });
        }

        public ExternalIDFilter make() {
            return new ExternalIDFilter(this.externalIdIndex);
        }
    }
}

