/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.typeconversions;

import elki.data.FeatureVector;
import elki.data.type.MultivariateSeriesTypeInformation;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorTypeInformation;
import elki.datasource.filter.AbstractStreamConversionFilter;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

public class MultivariateTimeSeriesFilter<V extends FeatureVector<?>>
extends AbstractStreamConversionFilter<V, V> {
    int variates;

    public MultivariateTimeSeriesFilter(int variates) {
        this.variates = variates;
    }

    @Override
    protected V filterSingleObject(V obj) {
        if (obj.getDimensionality() % this.variates != 0) {
            throw new AbortException("Vector length " + obj.getDimensionality() + " not divisible by the number of variates " + this.variates);
        }
        return obj;
    }

    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.FEATURE_VECTORS;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        VectorTypeInformation vin = (VectorTypeInformation)in;
        return new MultivariateSeriesTypeInformation(vin.getFactory(), in.getSerializer(), vin.mindim(), vin.maxdim(), this.variates);
    }

    public static class Par<V extends FeatureVector<?>>
    implements Parameterizer {
        public static final OptionID VARIATES_ID = new OptionID("series.variates", "Number of variates this time series has.");
        int variates;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(VARIATES_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.variates = x;
            });
        }

        public MultivariateTimeSeriesFilter<V> make() {
            return new MultivariateTimeSeriesFilter(this.variates);
        }
    }
}

