/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.typeconversions;

import elki.data.FeatureVector;
import elki.data.SparseNumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.filter.AbstractConversionFilter;
import elki.datasource.filter.FilterUtil;
import elki.logging.Logging;

public class SparseVectorFieldFilter<V extends SparseNumberVector>
extends AbstractConversionFilter<V, V> {
    private static final Logging LOG = Logging.getLogger(SparseVectorFieldFilter.class);
    int maxdim = -1;

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> in) {
        return true;
    }

    @Override
    protected void prepareProcessInstance(V obj) {
        this.maxdim = Math.max(this.maxdim, obj.getDimensionality());
    }

    @Override
    protected V filterSingleObject(V obj) {
        assert (this.maxdim > 0);
        obj.setDimensionality(this.maxdim);
        return obj;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> in) {
        SparseNumberVector.Factory factory = (SparseNumberVector.Factory)FilterUtil.guessFactory(in);
        return new VectorFieldTypeInformation((FeatureVector.Factory)factory, this.maxdim);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

