/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.filter.typeconversions;

import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.VectorFieldTypeInformation;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.filter.FilterUtil;
import elki.datasource.filter.ObjectFilter;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntListParameter;
import java.util.ArrayList;
import java.util.List;

public class SplitNumberVectorFilter<V extends NumberVector>
implements ObjectFilter {
    final int[] dims;

    public SplitNumberVectorFilter(int[] dims) {
        this.dims = dims;
    }

    public MultipleObjectsBundle filter(MultipleObjectsBundle objects) {
        if (objects.dataLength() == 0) {
            return objects;
        }
        MultipleObjectsBundle bundle = new MultipleObjectsBundle();
        for (int r = 0; r < objects.metaLength(); ++r) {
            SimpleTypeInformation type = objects.meta(r);
            List column = objects.getColumn(r);
            if (!this.getInputTypeRestriction().isAssignableFromType((TypeInformation)type)) {
                bundle.appendColumn(type, column);
                continue;
            }
            VectorFieldTypeInformation vtype = (VectorFieldTypeInformation)VectorFieldTypeInformation.class.cast(type);
            NumberVector.Factory factory = FilterUtil.guessFactory(vtype);
            VectorFieldTypeInformation type1 = new VectorFieldTypeInformation(factory, this.dims.length);
            VectorFieldTypeInformation type2 = new VectorFieldTypeInformation(factory, vtype.getDimensionality() - this.dims.length);
            ArrayList<NumberVector> col1 = new ArrayList<NumberVector>(column.size());
            ArrayList<NumberVector> col2 = new ArrayList<NumberVector>(column.size());
            bundle.appendColumn((SimpleTypeInformation)type1, col1);
            bundle.appendColumn((SimpleTypeInformation)type2, col2);
            int[] odims = new int[vtype.getDimensionality() - this.dims.length];
            int i = 0;
            for (int d = 0; d < vtype.getDimensionality(); ++d) {
                boolean found = false;
                for (int j = 0; j < this.dims.length; ++j) {
                    if (this.dims[j] != d) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (i >= odims.length) {
                    throw new AbortException("Dimensionalities not proper!");
                }
                odims[i] = d;
                ++i;
            }
            for (i = 0; i < objects.dataLength(); ++i) {
                int d;
                NumberVector obj = (NumberVector)column.get(i);
                double[] part1 = new double[this.dims.length];
                double[] part2 = new double[obj.getDimensionality() - this.dims.length];
                for (d = 0; d < this.dims.length; ++d) {
                    part1[d] = obj.doubleValue(this.dims[d]);
                }
                for (d = 0; d < odims.length; ++d) {
                    part2[d] = obj.doubleValue(odims[d]);
                }
                col1.add(factory.newNumberVector(part1));
                col2.add(factory.newNumberVector(part2));
            }
        }
        return bundle;
    }

    private TypeInformation getInputTypeRestriction() {
        int m = this.dims[0];
        for (int i = 1; i < this.dims.length; ++i) {
            m = Math.max(this.dims[i], m);
        }
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, (int)m, (int)Integer.MAX_VALUE);
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public static final OptionID SELECTED_ATTRIBUTES_ID = new OptionID("split.dims", "Dimensions to split into the first relation.");
        protected int[] dims;

        public void configure(Parameterization config) {
            ((IntListParameter)new IntListParameter(SELECTED_ATTRIBUTES_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST)).grab(config, x -> {
                this.dims = (int[])x.clone();
            });
        }

        public SplitNumberVectorFilter<V> make() {
            return new SplitNumberVectorFilter(this.dims);
        }
    }
}

