/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.database.ids.DBIDVar;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.parser.CSVReaderFormat;
import elki.datasource.parser.StreamingParser;
import elki.logging.Logging;
import elki.utilities.io.TokenizedReader;
import elki.utilities.io.Tokenizer;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractStreamingParser
implements StreamingParser {
    protected TokenizedReader reader;
    protected Tokenizer tokenizer;

    public AbstractStreamingParser(CSVReaderFormat format) {
        this.reader = format.makeReader();
        this.tokenizer = this.reader.getTokenizer();
    }

    @Override
    public final MultipleObjectsBundle parse(InputStream in) {
        this.initStream(in);
        return MultipleObjectsBundle.fromStream((BundleStreamSource)this);
    }

    @Override
    public void initStream(InputStream in) {
        this.reader.reset(in);
    }

    public boolean hasDBIDs() {
        return false;
    }

    public boolean assignDBID(DBIDVar var) {
        var.unset();
        return false;
    }

    public MultipleObjectsBundle asMultipleObjectsBundle() {
        return MultipleObjectsBundle.fromStream((BundleStreamSource)this);
    }

    @Override
    public void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            this.getLogger().exception((Throwable)e);
        }
    }

    protected abstract Logging getLogger();

    public static abstract class Par
    implements Parameterizer {
        protected CSVReaderFormat format;

        public void configure(Parameterization config) {
            this.format = (CSVReaderFormat)config.tryInstantiate(CSVReaderFormat.class);
        }

        public abstract AbstractStreamingParser make();
    }
}

