/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.BitVector;
import elki.data.LabelList;
import elki.datasource.parser.AbstractStreamingParser;
import elki.datasource.parser.CSVReaderFormat;
import elki.datasource.parser.NumberVectorLabelParser;
import elki.logging.Logging;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collection;

@Title(value="Bit Vector Label Parser")
@Description(value="Parses the following format of lines:\nA single line provides a single BitVector. Bits are separated by whitespace. Any substring not containing whitespace is tried to be read as Bit. If this fails, it will be appended to a label. (Thus, any label must not be parseable as Bit.) Empty lines and lines beginning with \"#\" will be ignored.")
public class BitVectorLabelParser
extends NumberVectorLabelParser<BitVector> {
    private static final Logging LOG = Logging.getLogger(BitVectorLabelParser.class);
    LongArrayList buf = new LongArrayList();

    public BitVectorLabelParser(CSVReaderFormat format) {
        super(format, (long[])null, BitVector.FACTORY);
    }

    @Override
    protected boolean parseLineInternal() {
        int curdim = 0;
        while (this.tokenizer.valid()) {
            try {
                int word = curdim >>> 6;
                int off = curdim & 0x3F;
                if (word >= this.buf.size()) {
                    this.buf.add(0L);
                }
                if (this.tokenizer.getIntBase10() > 0) {
                    this.buf.set(word, this.buf.getLong(word) | 1L << off);
                }
                ++curdim;
            }
            catch (NumberFormatException e) {
                this.labels.add(this.tokenizer.getSubstring());
            }
            this.tokenizer.advance();
        }
        if (curdim == 0) {
            return false;
        }
        this.curvec = new BitVector(this.buf.toLongArray(), curdim);
        this.curlbl = LabelList.make((Collection)this.labels);
        this.buf.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractStreamingParser.Par {
        @Override
        public BitVectorLabelParser make() {
            return new BitVectorLabelParser(this.format);
        }
    }
}

