/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.utilities.io.TokenizedReader;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.PatternParameter;
import elki.utilities.optionhandling.parameters.StringParameter;
import java.util.regex.Pattern;

public class CSVReaderFormat {
    public static final String DEFAULT_SEPARATOR = "\\s*[,;\\s]\\s*";
    public static final String QUOTE_CHARS = "\"'";
    public static final String NUMBER_PATTERN = "[+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?";
    public static final String COMMENT_PATTERN = "^\\s*(#|//|;).*$";
    public static final String ATTRIBUTE_CONCATENATION = " ";
    public static final CSVReaderFormat DEFAULT_FORMAT = new CSVReaderFormat(Pattern.compile("\\s*[,;\\s]\\s*"), "\"'", Pattern.compile("^\\s*(#|//|;).*$"));
    protected Pattern colSep = null;
    protected String quoteChars = "\"'";
    protected Pattern comment = null;

    public CSVReaderFormat(Pattern colSep, String quoteChars, Pattern comment) {
        this.colSep = colSep;
        this.quoteChars = quoteChars;
        this.comment = comment;
    }

    public TokenizedReader makeReader() {
        return new TokenizedReader(this.colSep, this.quoteChars, this.comment);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID COLUMN_SEPARATOR_ID = new OptionID("parser.colsep", "Column separator pattern. The default assumes whitespace separated data.");
        public static final OptionID QUOTE_ID = new OptionID("parser.quote", "Quotation characters. By default, both double and single ASCII quotes are accepted.");
        public static final OptionID COMMENT_ID = new OptionID("string.comment", "Ignore lines in the input file that satisfy this pattern.");
        protected Pattern colSep = null;
        protected String quoteChars = "\"'";
        protected Pattern comment = null;

        public void configure(Parameterization config) {
            new PatternParameter(COLUMN_SEPARATOR_ID, CSVReaderFormat.DEFAULT_SEPARATOR).grab(config, x -> {
                this.colSep = x;
            });
            new StringParameter(QUOTE_ID, CSVReaderFormat.QUOTE_CHARS).grab(config, x -> {
                this.quoteChars = x;
            });
            new PatternParameter(COMMENT_ID, CSVReaderFormat.COMMENT_PATTERN).grab(config, x -> {
                this.comment = x;
            });
        }

        public CSVReaderFormat make() {
            return new CSVReaderFormat(this.colSep, this.quoteChars, this.comment);
        }
    }
}

