/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.LabelList;
import elki.data.SparseFloatVector;
import elki.data.SparseNumberVector;
import elki.datasource.parser.NumberVectorLabelParser;
import elki.datasource.parser.SparseNumberVectorLabelParser;
import elki.logging.Logging;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Collection;
import java.util.regex.Pattern;

@Title(value="libSVM Format Parser")
public class LibSVMFormatParser<V extends SparseNumberVector>
extends SparseNumberVectorLabelParser<V> {
    private static final Logging LOG = Logging.getLogger(LibSVMFormatParser.class);
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+|:)");
    public static final Pattern COMMENT_PATTERN = Pattern.compile("#");

    public LibSVMFormatParser(SparseNumberVector.Factory<V> factory) {
        super(WHITESPACE_PATTERN, null, COMMENT_PATTERN, null, factory);
    }

    @Override
    protected boolean parseLineInternal() {
        int thismax = 0;
        this.labels.add(this.tokenizer.getSubstring());
        this.tokenizer.advance();
        this.haslabels = true;
        while (this.tokenizer.valid()) {
            try {
                int index = this.tokenizer.getIntBase10();
                this.tokenizer.advance();
                double attribute = this.tokenizer.getDouble();
                this.tokenizer.advance();
                thismax = Math.max(thismax, index + 1);
                this.values.put(index, attribute);
            }
            catch (NumberFormatException e) {
                String comment = this.tokenizer.getSubstring();
                if (comment.charAt(0) == '#') break;
                throw new RuntimeException("Parsing error in line " + this.reader.getLineNumber() + ": expected data, got " + comment);
            }
        }
        this.curvec = this.sparsefactory.newNumberVector(this.values, thismax);
        this.curlbl = LabelList.make((Collection)this.labels);
        this.values.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends SparseNumberVector>
    extends NumberVectorLabelParser.Par<V> {
        @Override
        protected void getFactory(Parameterization config) {
            new ObjectParameter(VECTOR_TYPE_ID, SparseNumberVector.Factory.class, SparseFloatVector.Factory.class).grab(config, x -> {
                this.factory = x;
            });
        }

        @Override
        public void configure(Parameterization config) {
            this.getFactory(config);
        }

        @Override
        public LibSVMFormatParser<V> make() {
            return new LibSVMFormatParser((SparseNumberVector.Factory)this.factory);
        }
    }
}

