/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.DoubleVector;
import elki.data.LabelList;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.data.type.VectorFieldTypeInformation;
import elki.data.type.VectorTypeInformation;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.parser.AbstractStreamingParser;
import elki.datasource.parser.CSVReaderFormat;
import elki.logging.Logging;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.datastructures.arraylike.DoubleArray;
import elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.ParseUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntListParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NumberVectorLabelParser<V extends NumberVector>
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(NumberVectorLabelParser.class);
    private long[] labelIndices;
    protected NumberVector.Factory<V> factory;
    protected int mindim;
    protected int maxdim;
    protected BundleMeta meta = null;
    protected List<String> columnnames = null;
    protected boolean haslabels = false;
    protected V curvec = null;
    protected LabelList curlbl = null;
    protected DoubleArray attributes = new DoubleArray(11);
    final ArrayList<String> labels = new ArrayList();
    ObjectOpenHashSet<String> unique = new ObjectOpenHashSet();
    BundleStreamSource.Event nextevent = null;
    boolean warnedPrecision = false;
    boolean warnedDim = false;

    public NumberVectorLabelParser(CSVReaderFormat format, long[] labelIndices, NumberVector.Factory<V> factory) {
        super(format);
        this.labelIndices = labelIndices;
        this.factory = factory;
    }

    public NumberVectorLabelParser(NumberVector.Factory<V> factory) {
        this(CSVReaderFormat.DEFAULT_FORMAT, null, factory);
    }

    public NumberVectorLabelParser(Pattern colSep, String quoteChars, Pattern comment, long[] labelIndices, NumberVector.Factory<V> factory) {
        this(new CSVReaderFormat(colSep, quoteChars, comment), labelIndices, factory);
    }

    protected boolean isLabelColumn(int col) {
        return this.labelIndices != null && BitsUtil.get((long[])this.labelIndices, (int)col);
    }

    @Override
    public void initStream(InputStream in) {
        super.initStream(in);
        this.mindim = Integer.MAX_VALUE;
        this.maxdim = 0;
        this.columnnames = null;
        this.haslabels = false;
        this.nextevent = null;
    }

    public BundleMeta getMeta() {
        return this.meta;
    }

    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event ret = this.nextevent;
            this.nextevent = null;
            return ret;
        }
        try {
            while (this.reader.nextLineExceptComments()) {
                if (!this.parseLineInternal()) continue;
                int curdim = this.curvec.getDimensionality();
                if (curdim > this.maxdim || this.mindim > curdim) {
                    this.mindim = curdim < this.mindim ? curdim : this.mindim;
                    int n = this.maxdim = curdim > this.maxdim ? curdim : this.maxdim;
                    if (!this.warnedDim && this.mindim != this.maxdim && LOG.isVerbose()) {
                        LOG.verbose((CharSequence)("Non-uniform column width detected in input line " + this.reader.getLineNumber() + ", widening data type to " + this.mindim + "-" + this.maxdim + " dimensions."));
                        this.warnedDim = true;
                    }
                    this.buildMeta();
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                if (this.curlbl != null && this.meta != null && this.haslabels && this.meta.size() == 1) {
                    this.buildMeta();
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                return BundleStreamSource.Event.NEXT_OBJECT;
            }
            if (this.maxdim == 0) {
                throw new AbortException("No numeric data was read in line " + this.reader.getLineNumber() + ". Verify the column separator; for textual data use other parsers.");
            }
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.unique.clear();
    }

    protected void buildMeta() {
        if (this.haslabels) {
            this.meta = new BundleMeta(2);
            this.meta.add(this.getTypeInformation(this.mindim, this.maxdim));
            this.meta.add((Object)TypeUtil.LABELLIST);
        } else {
            this.meta = new BundleMeta(1);
            this.meta.add(this.getTypeInformation(this.mindim, this.maxdim));
        }
    }

    public Object data(int rnum) {
        if (rnum > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return rnum == 0 ? this.curvec : this.curlbl;
    }

    protected boolean parseLineInternal() {
        int i = 0;
        while (this.tokenizer.valid()) {
            block6: {
                String lbl;
                block7: {
                    if (!this.isLabelColumn(i) && !this.tokenizer.isQuoted()) {
                        try {
                            this.attributes.add(this.tokenizer.getDouble());
                            break block6;
                        }
                        catch (NumberFormatException e) {
                            if (this.warnedPrecision || e != ParseUtil.PRECISION_OVERFLOW && e != ParseUtil.EXPONENT_OVERFLOW) break block7;
                            this.getLogger().warning((CharSequence)("Too many digits in what looked like a double number - treating as string: " + this.tokenizer.getSubstring()));
                            this.warnedPrecision = true;
                        }
                    }
                }
                if ((lbl = this.tokenizer.getStrippedSubstring()).length() > 0) {
                    this.haslabels = true;
                    lbl = (String)this.unique.addOrGet((Object)lbl);
                    this.labels.add(lbl);
                }
            }
            this.tokenizer.advance();
            ++i;
        }
        if (this.curvec == null && this.attributes.size == 0) {
            this.columnnames = new ArrayList<String>(this.labels);
            this.haslabels = false;
            this.curvec = null;
            this.curlbl = null;
            this.labels.clear();
            return false;
        }
        this.curvec = this.createVector();
        this.curlbl = LabelList.make(this.labels);
        this.attributes.clear();
        this.labels.clear();
        return true;
    }

    protected V createVector() {
        return (V)this.factory.newNumberVector((Object)this.attributes, (NumberArrayAdapter)this.attributes);
    }

    SimpleTypeInformation<V> getTypeInformation(int mindim, int maxdim) {
        if (mindim > maxdim) {
            throw new AbortException("No vectors were read from the input file - cannot determine vector data type.");
        }
        if (mindim == maxdim) {
            String[] colnames = null;
            if (this.columnnames != null && mindim <= this.columnnames.size()) {
                colnames = new String[mindim];
                int j = 0;
                int i = 0;
                while (j < mindim) {
                    if (!this.isLabelColumn(i)) {
                        colnames[j] = this.columnnames.get(i);
                        ++j;
                    }
                    ++i;
                }
                if (j != mindim) {
                    colnames = null;
                }
            }
            return new VectorFieldTypeInformation(this.factory, mindim, colnames);
        }
        return new VectorTypeInformation(this.factory, this.factory.getDefaultSerializer(), mindim, maxdim);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractStreamingParser.Par {
        public static final OptionID LABEL_INDICES_ID = new OptionID("parser.labelIndices", "A comma separated list of the indices of labels (may be numeric), counting whitespace separated entries in a line starting with 0. The corresponding entries will be treated as a label.");
        public static final OptionID VECTOR_TYPE_ID = new OptionID("parser.vector-type", "The type of vectors to create for numerical attributes.");
        protected long[] labelIndices;
        protected NumberVector.Factory<V> factory;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            this.getLabelIndices(config);
            this.getFactory(config);
        }

        protected void getFactory(Parameterization config) {
            new ObjectParameter(VECTOR_TYPE_ID, NumberVector.Factory.class, DoubleVector.Factory.class).grab(config, x -> {
                this.factory = x;
            });
        }

        protected void getLabelIndices(Parameterization config) {
            ((IntListParameter)new IntListParameter(LABEL_INDICES_ID).setOptional(true)).grab(config, x -> {
                this.labelIndices = BitsUtil.of((int[])x);
            });
        }

        @Override
        public NumberVectorLabelParser<V> make() {
            return new NumberVectorLabelParser<V>(this.format, this.labelIndices, this.factory);
        }
    }
}

