/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.ExternalID;
import elki.data.LabelList;
import elki.data.spatial.Polygon;
import elki.data.spatial.PolygonsObject;
import elki.data.type.TypeUtil;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.parser.AbstractStreamingParser;
import elki.datasource.parser.CSVReaderFormat;
import elki.logging.Logging;
import elki.utilities.io.ParseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimplePolygonParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(SimplePolygonParser.class);
    public static final Pattern COORD = Pattern.compile("^([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?),\\s*([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?)(?:,\\s*([+-]?(?:\\d+\\.?|\\d*\\.\\d+)?(?:[eE][-]?\\d+)?))?$");
    public static final String POLYGON_SEPARATOR = "--";
    BundleStreamSource.Event nextevent = null;
    protected BundleMeta meta = null;
    protected boolean haslabels = false;
    protected PolygonsObject curpoly = null;
    protected LabelList curlbl = null;
    protected ExternalID cureid = null;
    private final List<double[]> coords = new ArrayList<double[]>();
    private final List<Polygon> polys = new ArrayList<Polygon>();
    private final ArrayList<String> labels = new ArrayList();

    public SimplePolygonParser(CSVReaderFormat format) {
        super(format);
    }

    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event ret = this.nextevent;
            this.nextevent = null;
            return ret;
        }
        try {
            while (this.reader.nextLineExceptComments()) {
                if (!this.parseLine()) continue;
                if (this.meta == null || this.curlbl != null && !this.haslabels) {
                    this.haslabels = this.haslabels || this.curlbl != null;
                    this.buildMeta();
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                return BundleStreamSource.Event.META_CHANGED;
            }
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    protected void buildMeta() {
        if (this.haslabels) {
            this.meta = new BundleMeta(3);
            this.meta.add((Object)TypeUtil.POLYGON_TYPE);
            this.meta.add((Object)TypeUtil.EXTERNALID);
            this.meta.add((Object)TypeUtil.LABELLIST);
        } else {
            this.meta = new BundleMeta(2);
            this.meta.add((Object)TypeUtil.POLYGON_TYPE);
            this.meta.add((Object)TypeUtil.EXTERNALID);
        }
    }

    public BundleMeta getMeta() {
        return this.meta;
    }

    public Object data(int rnum) {
        if (rnum > (this.haslabels ? 2 : 1)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return rnum == 0 ? this.curpoly : (rnum == 1 ? this.cureid : this.curlbl);
    }

    private boolean parseLine() {
        this.cureid = null;
        this.curpoly = null;
        this.curlbl = null;
        this.polys.clear();
        this.coords.clear();
        this.labels.clear();
        Matcher m = COORD.matcher(this.reader.getBuffer());
        while (this.tokenizer.valid()) {
            block12: {
                m.region(this.tokenizer.getStart(), this.tokenizer.getEnd());
                if (m.find()) {
                    try {
                        double c1 = ParseUtil.parseDouble((CharSequence)m.group(1));
                        double c2 = ParseUtil.parseDouble((CharSequence)m.group(2));
                        if (m.group(3) != null) {
                            double c3 = ParseUtil.parseDouble((CharSequence)m.group(3));
                            this.coords.add(new double[]{c1, c2, c3});
                        } else {
                            this.coords.add(new double[]{c1, c2});
                        }
                        break block12;
                    }
                    catch (NumberFormatException e) {
                        LOG.warning((CharSequence)("Looked like a coordinate pair but didn't parse: " + this.tokenizer.getSubstring()));
                    }
                }
                int len = this.tokenizer.getEnd() - this.tokenizer.getStart();
                if (POLYGON_SEPARATOR.length() == len && this.reader.getBuffer().subSequence(this.tokenizer.getStart(), this.tokenizer.getEnd()).equals(POLYGON_SEPARATOR)) {
                    if (!this.coords.isEmpty()) {
                        this.polys.add(new Polygon(new ArrayList<double[]>(this.coords)));
                    }
                } else {
                    String cur = this.tokenizer.getSubstring();
                    if (this.cureid == null) {
                        this.cureid = new ExternalID(cur);
                    } else {
                        this.labels.add(cur);
                    }
                }
            }
            this.tokenizer.advance();
        }
        if (!this.coords.isEmpty()) {
            this.polys.add(new Polygon(this.coords));
        }
        this.curpoly = new PolygonsObject(this.polys);
        this.curlbl = this.haslabels || !this.labels.isEmpty() ? LabelList.make(this.labels) : null;
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractStreamingParser.Par {
        @Override
        public SimplePolygonParser make() {
            return new SimplePolygonParser(this.format);
        }
    }
}

