/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.BitVector;
import elki.data.FeatureVector;
import elki.data.type.VectorFieldTypeInformation;
import elki.data.type.VectorTypeInformation;
import elki.datasource.bundle.BundleMeta;
import elki.datasource.bundle.BundleStreamSource;
import elki.datasource.parser.AbstractStreamingParser;
import elki.datasource.parser.CSVReaderFormat;
import elki.logging.Logging;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.InputStream;

public class SimpleTransactionParser
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(SimpleTransactionParser.class);
    int numterms;
    Object2IntOpenHashMap<String> keymap;
    protected BundleMeta meta;
    BundleStreamSource.Event nextevent;
    BitVector curvec;
    LongArrayList buf = new LongArrayList();

    public SimpleTransactionParser(CSVReaderFormat format) {
        super(format);
        this.keymap = new Object2IntOpenHashMap();
        this.keymap.defaultReturnValue(-1);
    }

    @Override
    public void initStream(InputStream in) {
        super.initStream(in);
        this.nextevent = BundleStreamSource.Event.META_CHANGED;
    }

    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event ret = this.nextevent;
            this.nextevent = null;
            return ret;
        }
        try {
            if (this.reader.nextLineExceptComments()) {
                this.buf.clear();
                while (this.tokenizer.valid()) {
                    String token = this.tokenizer.getSubstring();
                    int t = this.keymap.getInt((Object)token);
                    if (t < 0) {
                        t = this.keymap.size();
                        this.keymap.put((Object)token, t);
                    }
                    int word = t >>> 6;
                    int off = t & 0x3F;
                    while (word >= this.buf.size()) {
                        this.buf.add(0L);
                    }
                    this.buf.set(word, this.buf.getLong(word) | 1L << off);
                    this.tokenizer.advance();
                }
                this.curvec = new BitVector(this.buf.toLongArray(), this.keymap.size());
                return BundleStreamSource.Event.NEXT_OBJECT;
            }
            this.nextevent = BundleStreamSource.Event.END_OF_STREAM;
            this.meta = new BundleMeta(1);
            String[] colnames = new String[this.keymap.size()];
            ObjectIterator iter = this.keymap.object2IntEntrySet().fastIterator();
            while (iter.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iter.next();
                colnames[entry.getIntValue()] = (String)entry.getKey();
            }
            this.meta.add((Object)new VectorFieldTypeInformation((FeatureVector.Factory)BitVector.FACTORY, colnames.length, colnames));
            return BundleStreamSource.Event.META_CHANGED;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.curvec = null;
    }

    public Object data(int rnum) {
        if (rnum != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.curvec;
    }

    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.meta = new BundleMeta(1);
            this.meta.add((Object)new VectorTypeInformation((FeatureVector.Factory)BitVector.FACTORY, BitVector.SHORT_SERIALIZER, 0, this.numterms));
        }
        return this.meta;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractStreamingParser.Par {
        @Override
        public SimpleTransactionParser make() {
            return new SimpleTransactionParser(this.format);
        }
    }
}

