/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.FeatureVector;
import elki.data.LabelList;
import elki.data.SparseFloatVector;
import elki.data.SparseNumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.VectorFieldTypeInformation;
import elki.data.type.VectorTypeInformation;
import elki.datasource.parser.CSVReaderFormat;
import elki.datasource.parser.NumberVectorLabelParser;
import elki.logging.Logging;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.exceptions.AbortException;
import elki.utilities.io.ParseUtil;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.regex.Pattern;

@Title(value="Sparse Vector Label Parser")
@Description(value="Parser for the following line format:\nA single line provides a single point. Entries are separated by whitespace. The values will be parsed as floats (resulting in a set of SparseFloatVectors).\nA line is expected in the following format:\nThe first entry of each line is the number of attributes with coordinate value not zero. Subsequent entries are of the form (index, value), where index is the number of the corresponding dimension, and value is the value of the corresponding attribute. Any pair of two subsequent substrings not containing whitespace is tried to be read as int and float. If this fails for the first of the pair (interpreted ans index), it will be appended to a label. (Thus, any label must not be parseable as Integer.) If the float component is not parseable, an exception will be thrown. Empty lines and lines beginning with \"#\" will be ignored.")
public class SparseNumberVectorLabelParser<V extends SparseNumberVector>
extends NumberVectorLabelParser<V> {
    private static final Logging LOG = Logging.getLogger(SparseNumberVectorLabelParser.class);
    protected SparseNumberVector.Factory<V> sparsefactory;
    Int2DoubleOpenHashMap values = new Int2DoubleOpenHashMap();
    ArrayList<String> labels = new ArrayList();

    public SparseNumberVectorLabelParser(CSVReaderFormat format, long[] labelIndices, SparseNumberVector.Factory<V> factory) {
        super(format, labelIndices, factory);
        this.sparsefactory = factory;
    }

    public SparseNumberVectorLabelParser(Pattern colSep, String quoteChars, Pattern comment, long[] labelIndices, SparseNumberVector.Factory<V> factory) {
        super(colSep, quoteChars, comment, labelIndices, factory);
        this.sparsefactory = factory;
    }

    @Override
    protected boolean parseLineInternal() {
        int cardinality;
        try {
            cardinality = this.tokenizer.getIntBase10();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Expected the number of values at the beginning of line " + this.reader.getLineNumber() + ", read '" + this.tokenizer.getSubstring() + "'");
        }
        this.tokenizer.advance();
        int thismax = 0;
        int index = -1;
        while (this.tokenizer.valid()) {
            block9: {
                if (this.values.size() < cardinality) {
                    try {
                        if (index < 0) {
                            index = this.tokenizer.getIntBase10();
                            this.tokenizer.advance();
                            continue;
                        }
                        if (!this.isLabelColumn(index)) {
                            double attribute = this.tokenizer.getDouble();
                            thismax = index >= thismax ? index + 1 : thismax;
                            this.values.put(index, attribute);
                            this.tokenizer.advance();
                            index = -1;
                            continue;
                        }
                    }
                    catch (NumberFormatException e) {
                        if (this.warnedPrecision || e != ParseUtil.PRECISION_OVERFLOW && e != ParseUtil.EXPONENT_OVERFLOW) break block9;
                        this.getLogger().warning((CharSequence)("Too many digits in what looked like a double number - treating as string: " + this.tokenizer.getSubstring()));
                        this.warnedPrecision = true;
                    }
                }
            }
            this.haslabels = true;
            this.labels.add(this.tokenizer.getSubstring());
            this.tokenizer.advance();
        }
        if (index >= 0 && !this.tokenizer.valid()) {
            throw new IllegalArgumentException("Parser expected double value, but line ended too early: " + this.reader.getLineNumber());
        }
        this.curvec = this.sparsefactory.newNumberVector(this.values, thismax);
        this.curlbl = LabelList.make(this.labels);
        this.values.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected SimpleTypeInformation<V> getTypeInformation(int mindim, int maxdim) {
        if (mindim == maxdim) {
            return new VectorFieldTypeInformation((FeatureVector.Factory)this.factory, mindim);
        }
        if (mindim < maxdim) {
            return new VectorTypeInformation((FeatureVector.Factory)this.factory, this.factory.getDefaultSerializer(), mindim, maxdim);
        }
        throw new AbortException("No vectors were read from the input file - cannot determine vector data type.");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends SparseNumberVector>
    extends NumberVectorLabelParser.Par<V> {
        @Override
        protected void getFactory(Parameterization config) {
            new ObjectParameter(VECTOR_TYPE_ID, SparseNumberVector.Factory.class, SparseFloatVector.Factory.class).grab(config, x -> {
                this.factory = x;
            });
        }

        @Override
        public SparseNumberVectorLabelParser<V> make() {
            return new SparseNumberVectorLabelParser(this.format, this.labelIndices, (SparseNumberVector.Factory)this.factory);
        }
    }
}

