/*
 * Decompiled with CFR 0.152.
 */
package elki.datasource.parser;

import elki.data.LabelList;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeUtil;
import elki.datasource.bundle.MultipleObjectsBundle;
import elki.datasource.parser.CSVReaderFormat;
import elki.datasource.parser.Parser;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.PatternParameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Title(value="String Parser")
@Description(value="Parses new line separated strings")
public class StringParser
implements Parser {
    Matcher comment;
    boolean trimWhitespace;

    public StringParser(Pattern comment, boolean trimWhitespace) {
        this.comment = comment != null ? comment.matcher("") : null;
        this.trimWhitespace = trimWhitespace;
    }

    @Override
    public MultipleObjectsBundle parse(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int lineNumber = 0;
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<LabelList> labels = new ArrayList<LabelList>();
        ArrayList<String> ll = new ArrayList<String>(1);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line.length() <= 0 || this.comment != null && this.comment.reset(line).matches())) {
                    String val = this.trimWhitespace ? line.trim() : line;
                    data.add(val);
                    ll.clear();
                    ll.add(val);
                    labels.add(LabelList.make(ll));
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while parsing line " + lineNumber + ".");
        }
        return MultipleObjectsBundle.makeSimple((SimpleTypeInformation)TypeUtil.STRING, data, (SimpleTypeInformation)TypeUtil.LABELLIST, labels);
    }

    @Override
    public void cleanup() {
        this.comment.reset("");
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID TRIM_ID = new OptionID("string.trim", "Remove leading and trailing whitespace from each line.");
        Pattern comment = null;
        boolean trimWhitespace = false;

        public void configure(Parameterization config) {
            new PatternParameter(CSVReaderFormat.Par.COMMENT_ID, "^\\s*#.*$").grab(config, x -> {
                this.comment = x;
            });
            new Flag(TRIM_ID).grab(config, x -> {
                this.trimWhitespace = x;
            });
        }

        public StringParser make() {
            return new StringParser(this.comment, this.trimWhitespace);
        }
    }
}

